/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.imro.harvester.parser;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import nl.b3p.imro.harvester.parser.Geleideformulier;
import nl.b3p.imro.harvester.parser.STRIParser;
import nl.b3p.imro.harvester.processing.HarvesterInitializer;
import nl.b3p.stri._2006._12b.GeleideFormulier;
import nl.b3p.stri._2006._12b.Manifest;
import nl.b3p.stri._2006._12b.Plan;

public class STRIParser2006
implements STRIParser {
    private final JAXBContext jaxbSTRIContext = JAXBContext.newInstance((String)"nl.b3p.stri._2006._12b");

    @Override
    public List<URL> getGeleideformulierURLSFromManifest(URL manifestURL) throws JAXBException, MalformedURLException {
        ArrayList<URL> geleideformulieren = new ArrayList<URL>();
        Unmarshaller jaxbUnmarshaller = this.jaxbSTRIContext.createUnmarshaller();
        Manifest manifest = (Manifest)jaxbUnmarshaller.unmarshal(manifestURL);
        List plannen = manifest.getPlan();
        for (Plan plan : plannen) {
            geleideformulieren.add(new URL(plan.getOnderdelen().getBasisURL() + plan.getOnderdelen().getGeleideFormulier()));
        }
        return geleideformulieren;
    }

    @Override
    public List<Geleideformulier> retrieveGeleideformulieren(List<URL> geleideformulieren) throws MalformedURLException, JAXBException {
        ArrayList<Geleideformulier> formulieren = new ArrayList<Geleideformulier>();
        Unmarshaller jaxbUnmarshaller = this.jaxbSTRIContext.createUnmarshaller();
        for (URL formulierURL : geleideformulieren) {
            GeleideFormulier striGeleideform = (GeleideFormulier)jaxbUnmarshaller.unmarshal(formulierURL);
            Plan plan = striGeleideform.getPlan();
            Plan.Eigenschappen eigenschappen = plan.getEigenschappen();
            if (HarvesterInitializer.canProcessPlantype(eigenschappen.getType().value())) {
                Geleideformulier geleideformulier = new Geleideformulier();
                Plan.Onderdelen onderdelen = plan.getOnderdelen();
                Plan.Supplementen supplementen = plan.getSupplementen();
                String identificatie = plan.getId();
                String basisURL = onderdelen.getBasisURL();
                geleideformulier.setIdentificatie(identificatie);
                geleideformulier.setNaam(eigenschappen.getNaam());
                geleideformulier.setType(eigenschappen.getType().value());
                geleideformulier.setStatus(eigenschappen.getStatus().value());
                geleideformulier.setDatum(eigenschappen.getDatum().toString());
                geleideformulier.setVersie(eigenschappen.getVersieIMRO());
                geleideformulier.setBasisURL(basisURL);
                geleideformulier.setImro(onderdelen.getIMRO());
                this.addBijlage(basisURL, onderdelen.getToelichting(), geleideformulier);
                this.addBijlage(basisURL, onderdelen.getToelichtingBijlage(), geleideformulier);
                this.addBijlage(basisURL, onderdelen.getBeleidsDocument(), geleideformulier);
                this.addBijlage(basisURL, onderdelen.getBeleidsDocumentBijlage(), geleideformulier);
                this.addBijlage(basisURL, onderdelen.getPlanKaart(), geleideformulier);
                this.addBijlage(basisURL, onderdelen.getVoorschriftenBijlage(), geleideformulier);
                this.addBijlage(basisURL, onderdelen.getGeleideFormulier(), geleideformulier);
                this.addBijlage(basisURL, onderdelen.getBesluitDocument(), geleideformulier);
                this.addBijlage(basisURL, onderdelen.getIMRO(), geleideformulier);
                for (String beleidsTekst : onderdelen.getBeleidsTekst()) {
                    geleideformulier.getBijlages().add(new URL(basisURL + beleidsTekst));
                }
                for (String voorschriften : onderdelen.getVoorschriften()) {
                    geleideformulier.getBijlages().add(new URL(basisURL + voorschriften));
                }
                formulieren.add(geleideformulier);
                continue;
            }
            throw new IllegalArgumentException("plantype onbekend: " + eigenschappen.getType());
        }
        return formulieren;
    }

    private void addBijlage(String basisURL, String bijlage, Geleideformulier geleideformulier) throws MalformedURLException {
        if (bijlage != null) {
            geleideformulier.getBijlages().add(new URL(basisURL + bijlage));
        }
    }
}

