/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.imro.harvester.processing;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;
import javax.persistence.RollbackException;
import javax.persistence.TypedQuery;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import nl.b3p.imro.harvester.entities.HarvestJob;
import nl.b3p.imro.harvester.entities.imro.Besluitgebied;
import nl.b3p.imro.harvester.entities.imro.Besluitvlak;
import nl.b3p.imro.harvester.entities.imro.Bestemmingsplan;
import nl.b3p.imro.harvester.entities.imro.Figuur;
import nl.b3p.imro.harvester.entities.imro.ImroEntity;
import nl.b3p.imro.harvester.entities.imro.Maatvoering;
import nl.b3p.imro.harvester.entities.imro.WaardeEnType;
import nl.b3p.imro.harvester.parser.Geleideformulier;
import nl.b3p.imro.harvester.parser.IMROParser;
import nl.b3p.imro.harvester.parser.ParserFactory;
import nl.b3p.imro.harvester.parser.STRIParser;
import nl.b3p.imro.harvester.processing.StatusReport;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom2.JDOMException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.stripesstuff.stripersist.Stripersist;
import org.xml.sax.SAXException;

public class Processor {
    private static final Log log = LogFactory.getLog(Processor.class);
    private Integer timeout;
    private List<HarvestJob> jobs = new ArrayList<HarvestJob>();
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private ParserFactory factory;
    private File downloadfolder;

    public Processor(List<HarvestJob> jobs, File downloadfolder) throws JAXBException {
        this(jobs, 30000, downloadfolder);
    }

    public Processor(List<HarvestJob> jobs, Integer timeout, File downloadfolder) throws JAXBException {
        this.jobs = jobs;
        this.timeout = timeout;
        this.factory = new ParserFactory();
        this.downloadfolder = downloadfolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() throws JDOMException {
        EntityManager em = Stripersist.getEntityManager();
        for (HarvestJob job : this.jobs) {
            StatusReport report = new StatusReport();
            try {
                job.setStatus(HarvestJob.HarvestJobStatus.BEZIG);
                em.persist((Object)job);
                em.getTransaction().commit();
                em.getTransaction().begin();
                URL manifestUrl = this.getManifestURL(job);
                try {
                    List<Geleideformulier> geleideformulieren = this.getGeleideformulierenFromManifestURL(manifestUrl, report);
                    for (Geleideformulier geleideformulier : geleideformulieren) {
                        report.addProcessed();
                        if (this.checkIfExists(geleideformulier, em)) {
                            report.addSkipped();
                            log.debug((Object)("Geleideformulier already in db: " + geleideformulier.toString()));
                            continue;
                        }
                        log.debug((Object)("Processing geleideformulier: " + geleideformulier.toString()));
                        try {
                            if (!em.getTransaction().isActive()) {
                                em.getTransaction().begin();
                            }
                            IMROParser parser = this.factory.getIMROParser(geleideformulier);
                            List<Object> planObjecten = parser.parseGML(geleideformulier);
                            for (Object plan : planObjecten) {
                                em.persist(plan);
                            }
                            this.downloadFiles(geleideformulier);
                            this.postprocess(planObjecten, em);
                            report.addLoaded(geleideformulier.getIdentificatie());
                            em.getTransaction().commit();
                        }
                        catch (MalformedURLException | URISyntaxException | RollbackException | JAXBException | ParserConfigurationException | TransformerException | SAXException ex) {
                            log.error((Object)("Cannot save entity in plan " + geleideformulier), ex);
                            em.getTransaction().rollback();
                            report.addErrored(geleideformulier.getIdentificatie(), (Exception)ex);
                        }
                        catch (PersistenceException | JDOMException ex) {
                            log.error((Object)("Cannot save entity in plan " + geleideformulier), ex);
                            em.getTransaction().rollback();
                            report.addErrored(geleideformulier.getIdentificatie(), (Exception)ex);
                        }
                        catch (Exception ex) {
                            log.error((Object)("Cannot save entity in plan " + geleideformulier), (Throwable)ex);
                            em.getTransaction().rollback();
                            report.addErrored(geleideformulier.getIdentificatie(), ex);
                        }
                    }
                }
                catch (IOException ex) {
                    log.error((Object)("Cannot get manifest url for HarvestJob " + job.getId() + " - " + job.getUrl()), (Throwable)ex);
                    report.addErrored(null, ex);
                }
                catch (ParseException ex) {
                    log.error((Object)("Cannot parse date" + job.getId() + " - " + job.getUrl()), (Throwable)ex);
                    report.addErrored(null, ex);
                }
            }
            catch (IOException ex) {
                log.error((Object)"Cannot parse manifest", (Throwable)ex);
                report.addFatal("Cannot parse manifest: " + ex.getMessage());
            }
            catch (JAXBException ex) {
                log.error((Object)"Cannot unmarshal manifest", (Throwable)ex);
                report.addFatal("Cannot unmarshal manifest: " + ex.getMessage());
            }
            catch (Exception e) {
                log.error((Object)"Fatal error occured", (Throwable)e);
                report.addFatal("Fatal: " + e.getMessage());
            }
            finally {
                job = (HarvestJob)em.find(HarvestJob.class, (Object)job.getId());
                if (report.wasFatal()) {
                    job.setStatus(HarvestJob.HarvestJobStatus.FATAAL);
                } else if (report.getPlansErrored().size() > 0) {
                    job.setStatus(HarvestJob.HarvestJobStatus.MEDIUMPROBLEEM);
                } else {
                    job.setStatus(HarvestJob.HarvestJobStatus.GOED);
                }
                job.setLog(report.getLog());
                if (!em.getTransaction().isActive()) {
                    em.getTransaction().begin();
                }
                job.setLastRunTime(new Date());
                em.persist((Object)job);
                em.getTransaction().commit();
            }
        }
    }

    protected void postprocess(List<Object> planObjecten, EntityManager em) {
        PlanType pt = this.getPlanType(planObjecten);
        if (pt == PlanType.BESTEMMINGSPLANGEBIED) {
            Bestemmingsplan bp = null;
            for (Object obj : planObjecten) {
                if (!(obj instanceof Bestemmingsplan)) continue;
                bp = (Bestemmingsplan)obj;
                break;
            }
            for (Object obj : planObjecten) {
                if (obj instanceof ImroEntity) {
                    ImroEntity ie = (ImroEntity)obj;
                    ie.setBestemmingsplan(bp);
                } else if (obj instanceof Figuur) {
                    Figuur f = (Figuur)obj;
                    f.setBestemmingsplan(bp);
                }
                if (obj instanceof Maatvoering) {
                    Maatvoering mv = (Maatvoering)obj;
                    for (WaardeEnType waardeEnType : mv.getWaardeEnType()) {
                        waardeEnType.setMaatvoering(mv);
                        em.persist((Object)waardeEnType);
                    }
                }
                em.persist(obj);
            }
        } else if (pt == PlanType.OMGEVINGSVERGUNNING) {
            Besluitgebied bg = null;
            for (Object obj : planObjecten) {
                if (!(obj instanceof Besluitgebied)) continue;
                bg = (Besluitgebied)obj;
                break;
            }
            if (bg != null) {
                for (Object obj : planObjecten) {
                    if (!(obj instanceof Besluitvlak)) continue;
                    Besluitvlak bv = (Besluitvlak)obj;
                    bv.setBesluitgebied(bg);
                }
            }
        } else {
            throw new IllegalArgumentException("Plantype unknown. " + (Object)((Object)pt));
        }
    }

    protected PlanType getPlanType(List<Object> planObjecten) {
        PlanType type = null;
        for (Object planObject : planObjecten) {
            if (planObject instanceof Bestemmingsplan) {
                type = PlanType.BESTEMMINGSPLANGEBIED;
                break;
            }
            if (!(planObject instanceof Besluitgebied) && !(planObject instanceof Besluitvlak)) continue;
            type = PlanType.OMGEVINGSVERGUNNING;
            break;
        }
        return type;
    }

    protected URL getManifestURL(HarvestJob job) throws IOException {
        if (job.getType() == null || job.getType() == HarvestJob.HarvestJobType.DIRECT) {
            return new URL(job.getUrl());
        }
        URL u = new URL(job.getUrl());
        Document doc = Jsoup.parse((URL)u, (int)this.timeout);
        return this.getManifestFromHTMLDocument(doc);
    }

    protected URL getManifestURL(File f) throws IOException {
        Document doc = Jsoup.parse((File)f, (String)"UTF-8");
        return this.getManifestFromHTMLDocument(doc);
    }

    private URL getManifestFromHTMLDocument(Document doc) throws MalformedURLException {
        Elements els = doc.select("a.external");
        Element link = els.first();
        String url = link.attr("href");
        return new URL(url);
    }

    public boolean checkIfExists(Geleideformulier formulier, EntityManager em) throws ParseException {
        TypedQuery q = em.createQuery("FROM Bestemmingsplan WHERE naam = :naam and typePlan = :typePlan and planstatusDatum = :datum and planstatusInfo = :status and identificatie = :identificatie", Bestemmingsplan.class).setParameter("naam", (Object)formulier.getNaam()).setParameter("typePlan", (Object)formulier.getType()).setParameter("status", (Object)formulier.getStatus()).setParameter("identificatie", (Object)formulier.getIdentificatie()).setParameter("datum", (Object)this.sdf.parse(formulier.getDatum()));
        List plannen = q.getResultList();
        if (plannen.size() > 0) {
            return true;
        }
        q = em.createQuery("FROM Besluitgebied WHERE naam = :naam and typePlan = :typePlan and planstatusDatum = :datum and planstatus = :status and identificatie = :identificatie", Besluitgebied.class).setParameter("naam", (Object)formulier.getNaam()).setParameter("typePlan", (Object)formulier.getType()).setParameter("status", (Object)formulier.getStatus()).setParameter("identificatie", (Object)formulier.getIdentificatie()).setParameter("datum", (Object)this.sdf.parse(formulier.getDatum()));
        List gebieden = q.getResultList();
        return gebieden.size() > 0;
    }

    public List<Geleideformulier> getGeleideformulierenFromManifestURL(URL manifest, StatusReport report) throws IOException, JDOMException, JAXBException {
        ArrayList<Geleideformulier> forms = new ArrayList<Geleideformulier>();
        STRIParser striParser = this.factory.getSTRIParser(manifest);
        List<URL> geleideformulierenURLS = striParser.getGeleideformulierURLSFromManifest(manifest);
        for (URL geleideformulierURL : geleideformulierenURLS) {
            try {
                striParser = this.factory.getSTRIParser(geleideformulierURL);
                forms.addAll(striParser.retrieveGeleideformulieren(Collections.singletonList(geleideformulierURL)));
            }
            catch (IOException ex) {
                log.debug((Object)("Cannot retrieve geleideformulier: " + geleideformulierURL + " " + ex.getLocalizedMessage()));
                report.addErrored(geleideformulierURL.toExternalForm(), ex);
            }
            catch (JAXBException | JDOMException ex) {
                log.debug((Object)("Parsing failed of geleideformulier: " + geleideformulierURL), ex);
                report.addErrored(geleideformulierURL.toExternalForm(), (Exception)ex);
            }
            catch (IllegalArgumentException ex) {
                log.debug((Object)("Plan uit geleideformulier: " + geleideformulierURL + " niet verwerkt, reden: " + ex.getLocalizedMessage()));
                report.addErrored(geleideformulierURL.toExternalForm(), ex);
            }
        }
        return forms;
    }

    protected void downloadFiles(Geleideformulier formulier) throws IOException {
        File newDir = new File(this.downloadfolder, formulier.getIdentificatie());
        boolean created = newDir.mkdir();
        if (!created && !newDir.exists()) {
            throw new IOException("Cannot create new directory for saving files");
        }
        for (URL bijlage : formulier.getBijlages()) {
            this.downloadUrl(bijlage, newDir);
        }
    }

    private void downloadUrl(URL url, File dir) throws IOException {
        String filename = url.getFile();
        if (filename.indexOf("/") != -1) {
            filename = filename.substring(filename.lastIndexOf("/") + 1);
        }
        FileUtils.copyURLToFile((URL)url, (File)new File(dir, filename));
    }

    public static enum PlanType {
        BESTEMMINGSPLANGEBIED("bestemmingplangebied"),
        OMGEVINGSVERGUNNING("omgevingsvergunning");

        private final String value;

        private PlanType(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static PlanType fromValue(String v) {
            for (PlanType c : PlanType.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

