/*
 * Copyright (C) 2016 B3Partners B.V.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package nl.b3p.imro.harvester.parser;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author Meine Toonen meinetoonen@b3partners.nl
 */
public class Geleideformulier {


    private String identificatie;

    private String basisURL;

    private String status;

    private String datum;

    private String versie;

    private String naam;

    private String type;

    private String imro;

    private List<URL> bijlages = new ArrayList<URL>();

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getNaam() {
        return naam;
    }

    public void setNaam(String naam) {
        this.naam = naam;
    }

    public String getIdentificatie() {
        return identificatie;
    }

    public void setIdentificatie(String identificatie) {
        this.identificatie = identificatie;
    }

    public String getBasisURL() {
        return basisURL;
    }

    public void setBasisURL(String basisURL) {
        this.basisURL = basisURL;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getDatum() {
        return datum;
    }

    public void setDatum(String datum) {
        this.datum = datum;
    }

    public String getVersie() {
        return versie;
    }

    public void setVersie(String versie) {
        this.versie = versie;
    }

    public URL getGML() throws MalformedURLException{
        URL u = new URL(this.getBasisURL() + this.getImro());
        return u;
    }

    public String getImro() {
        return imro;
    }

    public void setImro(String imro) {
        this.imro = imro;
    }

    public List<URL> getBijlages() {
        return bijlages;
    }

    public void setBijlages(List<URL> bijlages) {
        this.bijlages = bijlages;
    }

    @Override
    public String toString(){
        return identificatie + " from " + basisURL + ": " + getStatus() + " - " + getDatum();
    }
}
