/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.imro.harvester.parser;

import java.io.IOException;
import java.net.URL;
import javax.xml.bind.JAXBException;
import nl.b3p.imro.harvester.parser.Geleideformulier;
import nl.b3p.imro.harvester.parser.IMROParser;
import nl.b3p.imro.harvester.parser.IMROParser2008;
import nl.b3p.imro.harvester.parser.IMROParser2012_10;
import nl.b3p.imro.harvester.parser.IMROParser2012_11;
import nl.b3p.imro.harvester.parser.STRIParser;
import nl.b3p.imro.harvester.parser.STRIParser2006;
import nl.b3p.imro.harvester.parser.STRIParser2008;
import nl.b3p.imro.harvester.parser.STRIParser2012;
import nl.b3p.imro.harvester.processing.ROType;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
public class ParserFactory {
    private IMROParser2008 imro2008 = new IMROParser2008();
    private IMROParser2012_10 imro2012V10 = new IMROParser2012_10();
    private IMROParser2012_11 imro2012V11 = new IMROParser2012_11();
    private STRIParser2012 stri2012 = new STRIParser2012();
    private STRIParser2008 stri2008 = new STRIParser2008();
    private STRIParser2006 stri2006 = new STRIParser2006();
    protected static final Element STRI2006_ROOTELEMENT_MANIFEST = new Element("Manifest", Namespace.getNamespace((String)"http://www.geonovum.nl/stri/2006/1"));
    protected static final Element STRI2006_ROOTELEMENT_GELEIDEFORMULIER = new Element("GeleideFormulier", Namespace.getNamespace((String)"http://www.geonovum.nl/stri/2006/1"));
    protected static final Element STRI2008_ROOTELEMENT_MANIFEST = new Element("Manifest", Namespace.getNamespace((String)"http://www.geonovum.nl/stri/2008/1"));
    protected static final Element STRI2008_ROOTELEMENT_GELEIDEFORMULIER = new Element("GeleideFormulier", Namespace.getNamespace((String)"http://www.geonovum.nl/stri/2008/1"));
    protected static final Element STRI2012V1_ROOTELEMENT_MANIFEST = new Element("Manifest", Namespace.getNamespace((String)"http://www.geonovum.nl/stri/2012/1.0"));
    protected static final Element STRI2012V1_ROOTELEMENT_GELEIDEFORMULIER = new Element("GeleideFormulier", Namespace.getNamespace((String)"http://www.geonovum.nl/stri/2012/1.0"));
    protected static final Element STRI2012V2_ROOTELEMENT_MANIFEST = new Element("Manifest", Namespace.getNamespace((String)"http://www.geonovum.nl/stri/2012/2.0"));
    protected static final Element STRI2012V2_ROOTELEMENT_GELEIDEFORMULIER = new Element("GeleideFormulier", Namespace.getNamespace((String)"http://www.geonovum.nl/stri/2012/2.0"));
    protected static final Element IMRO2008_ROOTELEMENT = new Element("FeatureCollectionIMRO", Namespace.getNamespace((String)"http://www.geonovum.nl/imro/2008/1"));
    protected static final Element IMRO2012V10_ROOTELEMENT = new Element("FeatureCollectionIMRO", Namespace.getNamespace((String)"http://www.geonovum.nl/imro/2012/1.0"));
    protected static final Element IMRO2012V11_ROOTELEMENT = new Element("FeatureCollectionIMRO", Namespace.getNamespace((String)"http://www.geonovum.nl/imro/2012/1.1"));

    public STRIParser getSTRIParser(URL u) throws IOException, JDOMException {
        ROType type = ParserFactory.getROType((URL)u);
        if (type.equals((Object)ROType.STRI2012)) {
            return this.stri2012;
        }
        if (type.equals((Object)ROType.STRI2008)) {
            return this.stri2008;
        }
        if (type.equals((Object)ROType.STRI2006)) {
            return this.stri2006;
        }
        throw new UnsupportedOperationException("Not Yet implemented stri version " + type);
    }

    public IMROParser getIMROParser(Geleideformulier geleideformulier) throws IOException, JDOMException, JAXBException {
        ROType type = ParserFactory.getROType((URL)geleideformulier.getGML());
        if (type.equals((Object)ROType.IMRO2008)) {
            return this.imro2008;
        }
        if (type.equals((Object)ROType.IMRO2012V10)) {
            return this.imro2012V10;
        }
        if (type.equals((Object)ROType.IMRO2012V11)) {
            return this.imro2012V11;
        }
        throw new IllegalArgumentException("Class not yet implented");
    }

    public static ROType getROType(URL inputXmlFullPath) throws IOException, JDOMException {
        Document inputXml = new SAXBuilder().build(inputXmlFullPath);
        if (!inputXml.hasRootElement()) {
            throw new IllegalArgumentException("Document contains no root element");
        }
        Element rootElem = inputXml.getRootElement();
        if (ParserFactory.isElementEqual((Element)rootElem, (Element)IMRO2008_ROOTELEMENT)) {
            return ROType.IMRO2008;
        }
        if (ParserFactory.isElementEqual((Element)rootElem, (Element)IMRO2012V10_ROOTELEMENT)) {
            return ROType.IMRO2012V10;
        }
        if (ParserFactory.isElementEqual((Element)rootElem, (Element)IMRO2012V11_ROOTELEMENT)) {
            return ROType.IMRO2012V11;
        }
        if (ParserFactory.isElementEqual((Element)rootElem, (Element)STRI2012V1_ROOTELEMENT_GELEIDEFORMULIER) || ParserFactory.isElementEqual((Element)rootElem, (Element)STRI2012V1_ROOTELEMENT_MANIFEST) || ParserFactory.isElementEqual((Element)rootElem, (Element)STRI2012V2_ROOTELEMENT_GELEIDEFORMULIER) || ParserFactory.isElementEqual((Element)rootElem, (Element)STRI2012V2_ROOTELEMENT_MANIFEST)) {
            return ROType.STRI2012;
        }
        if (ParserFactory.isElementEqual((Element)rootElem, (Element)STRI2008_ROOTELEMENT_GELEIDEFORMULIER) || ParserFactory.isElementEqual((Element)rootElem, (Element)STRI2008_ROOTELEMENT_MANIFEST)) {
            return ROType.STRI2008;
        }
        if (ParserFactory.isElementEqual((Element)rootElem, (Element)STRI2006_ROOTELEMENT_GELEIDEFORMULIER) || ParserFactory.isElementEqual((Element)rootElem, (Element)STRI2006_ROOTELEMENT_MANIFEST)) {
            return ROType.STRI2006;
        }
        throw new IllegalArgumentException("Unrecognized root element: " + rootElem);
    }

    private static boolean isElementEqual(Element elem1, Element elem2) {
        return elem1.getName().equals(elem2.getName()) && elem1.getNamespaceURI().equals(elem2.getNamespaceURI());
    }
}

