/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.imro.harvester.parser;

import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import nl.b3p.imro._2008._11.BesluitgebiedXType;
import nl.b3p.imro._2008._11.BesluitsubvlakXPropertyType;
import nl.b3p.imro._2008._11.BesluitsubvlakXType;
import nl.b3p.imro._2008._11.BesluitvlakXPropertyType;
import nl.b3p.imro._2008._11.BesluitvlakXType;
import nl.b3p.imro._2008._11.BestemmingsplangebiedType;
import nl.b3p.imro._2008._11.BestemmingsvlakPropertyType;
import nl.b3p.imro._2008._11.BouwaanduidingType;
import nl.b3p.imro._2008._11.BouwvlakType;
import nl.b3p.imro._2008._11.DubbelbestemmingType;
import nl.b3p.imro._2008._11.EnkelbestemmingType;
import nl.b3p.imro._2008._11.ExternPlanReferentieXGBPropertyType;
import nl.b3p.imro._2008._11.FeatureCollectionIMROType;
import nl.b3p.imro._2008._11.FiguurType;
import nl.b3p.imro._2008._11.FunctieaanduidingType;
import nl.b3p.imro._2008._11.GebiedsaanduidingType;
import nl.b3p.imro._2008._11.IllustratieReferentieXGBPropertyType;
import nl.b3p.imro._2008._11.MaatvoeringType;
import nl.b3p.imro._2008._11.MetadataIMRObestandType;
import nl.b3p.imro._2008._11.NormadressantXGBType;
import nl.b3p.imro._2008._11.TekstReferentieBGXGBPropertyType;
import nl.b3p.imro._2008._11.TekstReferentieXGBPropertyType;
import nl.b3p.imro._2008._11.WaardeEnTypePropertyType;
import nl.b3p.imro._2008._11.WaardeEnTypeType;
import nl.b3p.imro.harvester.entities.imro.Besluitgebied;
import nl.b3p.imro.harvester.entities.imro.Besluitsubvlak;
import nl.b3p.imro.harvester.entities.imro.Besluitvlak;
import nl.b3p.imro.harvester.entities.imro.Bestemmingsplan;
import nl.b3p.imro.harvester.entities.imro.Bouwaanduiding;
import nl.b3p.imro.harvester.entities.imro.Bouwvlak;
import nl.b3p.imro.harvester.entities.imro.Dubbelbestemming;
import nl.b3p.imro.harvester.entities.imro.Enkelbestemming;
import nl.b3p.imro.harvester.entities.imro.Figuur;
import nl.b3p.imro.harvester.entities.imro.Functieaanduiding;
import nl.b3p.imro.harvester.entities.imro.Gebiedsaanduiding;
import nl.b3p.imro.harvester.entities.imro.Maatvoering;
import nl.b3p.imro.harvester.entities.imro.WaardeEnType;
import nl.b3p.imro.harvester.parser.Geleideformulier;
import nl.b3p.imro.harvester.parser.IMROParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public class IMROParser2008
implements IMROParser {
    protected static final Log log = LogFactory.getLog(IMROParser2008.class);
    private JAXBContext context = JAXBContext.newInstance((String)"nl.b3p.imro._2008._11");

    @Override
    public List<Object> parseGML(Geleideformulier geleideformulier) throws JAXBException, URISyntaxException, MalformedURLException, IOException, ParserConfigurationException, SAXException, TransformerException {
        return this.parseGML(geleideformulier.getGML());
    }

    @Override
    public List<Object> parseGML(URL u) throws JAXBException, IOException, ParserConfigurationException, SAXException, TransformerException {
        Object value = this.unmarshalUrl(u);
        FeatureCollectionIMROType fc = (FeatureCollectionIMROType)value;
        List<Object> bp = this.processFeatureCollection(fc);
        return bp;
    }

    @Override
    public Object unmarshalUrl(URL u) throws JAXBException {
        Unmarshaller jaxbUnmarshaller = this.context.createUnmarshaller();
        JAXBElement o = (JAXBElement)jaxbUnmarshaller.unmarshal(u);
        Object value = o.getValue();
        return value;
    }

    @Override
    public List<Object> processFeatureCollection(Object featureCollection) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        FeatureCollectionIMROType fc = (FeatureCollectionIMROType)featureCollection;
        ArrayList<Object> objs = new ArrayList<Object>();
        List members = fc.getFeatureMember();
        for (FeatureCollectionIMROType.FeatureMember member : members) {
            Object o = member.getFeature().getValue();
            Object parsed = this.parseFeatureMember(o);
            if (parsed == null) continue;
            objs.add(parsed);
        }
        return objs;
    }

    @Override
    public Object parseFeatureMember(Object o) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        Gebiedsaanduiding obj = null;
        if (o instanceof GebiedsaanduidingType) {
            obj = this.parseImroGebiedsaanduiding(o);
        } else if (o instanceof BestemmingsplangebiedType) {
            obj = this.parseImroBestemmingsplan(o);
        } else if (o instanceof DubbelbestemmingType) {
            obj = this.parseImroDubbelbestemming(o);
        } else if (o instanceof EnkelbestemmingType) {
            obj = this.parseImroEnkelbestemming(o);
        } else if (o instanceof MaatvoeringType) {
            obj = this.parseImroMaatvoering(o);
        } else if (o instanceof BouwvlakType) {
            obj = this.parseImroBouwvlak(o);
        } else if (o instanceof FunctieaanduidingType) {
            obj = this.parseImroFunctieaanduiding(o);
        } else if (o instanceof FiguurType) {
            obj = this.parseImroFiguur(o);
        } else if (o instanceof BouwaanduidingType) {
            obj = this.parseImroBouwaanduiding(o);
        } else if (o instanceof BesluitvlakXType) {
            obj = this.parseImroBesluitvlak(o);
        } else if (o instanceof BesluitgebiedXType) {
            obj = this.parseImroBesluitgebied(o);
        } else if (!(o instanceof MetadataIMRObestandType)) {
            log.error((Object)("Unknown type of featuremember when parsing. Class encountered: " + o.getClass().toString()));
        }
        return obj;
    }

    @Override
    public Bestemmingsplan parseImroBestemmingsplan(Object o) {
        Bestemmingsplan bp = new Bestemmingsplan();
        BestemmingsplangebiedType bpgt = (BestemmingsplangebiedType)o;
        String identificatie = this.getIdentificatie(bpgt.getIdentificatie());
        bp.setTypePlan(bpgt.getTypePlan().value());
        bp.setIdentificatie(identificatie);
        bp.setBeleidsmatigeVerantwoordelijkeOverheid(bpgt.getBeleidsmatigVerantwoordelijkeOverheid().value());
        bp.setBesluitnummer(bpgt.getBesluitnummer());
        bp.setNaam(bpgt.getNaam().getValue());
        if (bpgt.getLocatieNaam().size() > 0) {
            bp.setLocatieNaam((String)bpgt.getLocatieNaam().get(0));
        }
        bp.setNaamOverheid(bpgt.getNaamOverheid());
        bp.setOverheidsCode(bpgt.getOverheidsCode());
        bp.setPlanstatusInfo(bpgt.getPlanstatusInfo().getPlanstatusEnDatumBP().getPlanstatus().value());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            bp.setPlanstatusDatum(sdf.parse(bpgt.getPlanstatusInfo().getPlanstatusEnDatumBP().getDatum()));
        }
        catch (ParseException ex) {
            log.debug((Object)("Cannot parse datestring: " + bpgt.getPlanstatusInfo().getPlanstatusEnDatumBP().getDatum()), (Throwable)ex);
        }
        bp.setTypePlan(bpgt.getTypePlan().value());
        try {
            MultiPolygon g = gc.convertMultiPolygonGeometry(bpgt.getGeometrie());
            bp.setGeometrie(g);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bp;
    }

    @Override
    public Dubbelbestemming parseImroDubbelbestemming(Object o) {
        Dubbelbestemming db = new Dubbelbestemming();
        DubbelbestemmingType dbt = (DubbelbestemmingType)o;
        String identificatie = this.getIdentificatie(dbt.getIdentificatie());
        db.setArtikelnummer(dbt.getArtikelnummer());
        db.setBestemmingshoofdgroep(dbt.getBestemmingshoofdgroep().value());
        db.setIdentificatie(identificatie);
        db.setNaam(dbt.getNaam().getValue());
        db.setTypePlanObject(dbt.getTypePlanobject().value());
        db.setVerwijzing(dbt.getVerwijzingNaarTekstInfo().getTekstReferentieBP().getVerwijzingNaarTekst());
        try {
            MultiPolygon g = gc.convertMultiPolygonGeometry(dbt.getGeometrie());
            db.setGeometrie(g);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return db;
    }

    @Override
    public Gebiedsaanduiding parseImroGebiedsaanduiding(Object o) {
        Gebiedsaanduiding gba = new Gebiedsaanduiding();
        GebiedsaanduidingType ga = (GebiedsaanduidingType)o;
        String identificatie = this.getIdentificatie(ga.getIdentificatie());
        gba.setNaam(ga.getNaam());
        gba.setIdentificatie(identificatie);
        gba.setArtikelnummer(ga.getArtikelnummer());
        gba.setGebiedsaanduidinggroep(ga.getGebiedsaanduidinggroep());
        gba.setTypePlanObject(ga.getTypePlanobject().value());
        gba.setVerwijzing(ga.getVerwijzingNaarTekstInfo().getTekstReferentieBP().getVerwijzingNaarTekst());
        try {
            MultiPolygon g = gc.convertMultiPolygonGeometry(ga.getPlangebied());
            gba.setGeometrie(g);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return gba;
    }

    @Override
    public Bouwvlak parseImroBouwvlak(Object o) {
        Bouwvlak bv = new Bouwvlak();
        BouwvlakType bvt = (BouwvlakType)o;
        String identificatie = this.getIdentificatie(bvt.getIdentificatie());
        bv.setIdentificatie(identificatie);
        bv.setNaam(bvt.getNaam().getValue());
        bv.setTypePlanObject(bvt.getTypePlanobject().value());
        BestemmingsvlakPropertyType bt = (BestemmingsvlakPropertyType)bvt.getBestemmingsvlak().get(0);
        bv.setEnkelbestemming(bt.getHref().substring(1));
        try {
            MultiPolygon g = gc.convertMultiPolygonGeometry(bvt.getPlangebied());
            bv.setGeometrie(g);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bv;
    }

    @Override
    public Functieaanduiding parseImroFunctieaanduiding(Object o) {
        Functieaanduiding fa = new Functieaanduiding();
        FunctieaanduidingType fat = (FunctieaanduidingType)o;
        String identificatie = this.getIdentificatie(fat.getIdentificatie());
        fa.setIdentificatie(identificatie);
        fa.setNaam(fat.getNaam());
        fa.setTypePlanObject(fat.getTypePlanobject().value());
        if (fat.getBestemmingsvlak().size() > 0) {
            BestemmingsvlakPropertyType bt = (BestemmingsvlakPropertyType)fat.getBestemmingsvlak().get(0);
            fa.setEnkelbestemming(bt.getHref().substring(1));
        }
        try {
            MultiPolygon g = gc.convertMultiPolygonGeometry(fat.getPlangebied());
            fa.setGeometrie(g);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fa;
    }

    @Override
    public Figuur parseImroFiguur(Object o) {
        Figuur fa = new Figuur();
        FiguurType fat = (FiguurType)o;
        String identificatie = this.getIdentificatie(fat.getIdentificatie());
        fa.setIdentificatie(identificatie);
        fa.setNaam(fat.getNaam());
        fa.setTypePlanObject(fat.getTypePlanobject().value());
        if (fat.getBestemmingsvlak().size() > 0) {
            BestemmingsvlakPropertyType bt = (BestemmingsvlakPropertyType)fat.getBestemmingsvlak().get(0);
            fa.setEnkelbestemming(bt.getHref().substring(1));
        }
        try {
            MultiLineString g = gc.convertMultiLineStringGeometry(fat.getPlangebied());
            fa.setGeometrie(g);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fa;
    }

    @Override
    public Bouwaanduiding parseImroBouwaanduiding(Object o) {
        Bouwaanduiding ba = new Bouwaanduiding();
        BouwaanduidingType fat = (BouwaanduidingType)o;
        String identificatie = this.getIdentificatie(fat.getIdentificatie());
        ba.setIdentificatie(identificatie);
        ba.setNaam(fat.getNaam());
        ba.setTypePlanObject(fat.getTypePlanobject().value());
        if (fat.getBestemmingsvlak().size() > 0) {
            BestemmingsvlakPropertyType bt = (BestemmingsvlakPropertyType)fat.getBestemmingsvlak().get(0);
            ba.setEnkelbestemming(bt.getHref().substring(1));
        }
        try {
            MultiPolygon g = gc.convertMultiPolygonGeometry(fat.getPlangebied());
            ba.setGeometrie(g);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ba;
    }

    @Override
    public Enkelbestemming parseImroEnkelbestemming(Object o) {
        Enkelbestemming eb = new Enkelbestemming();
        EnkelbestemmingType ebt = (EnkelbestemmingType)o;
        String identificatie = this.getIdentificatie(ebt.getIdentificatie());
        eb.setArtikelnummer(ebt.getArtikelnummer());
        eb.setBestemmingshoofdgroep(ebt.getBestemmingshoofdgroep().value());
        eb.setIdentificatie(identificatie);
        eb.setNaam(ebt.getNaam().getValue());
        eb.setTypePlanObject(ebt.getTypePlanobject().value());
        eb.setVerwijzing(ebt.getVerwijzingNaarTekstInfo().getTekstReferentieBP().getVerwijzingNaarTekst());
        try {
            MultiPolygon g = gc.convertMultiPolygonGeometry(ebt.getGeometrie());
            eb.setGeometrie(g);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return eb;
    }

    @Override
    public Maatvoering parseImroMaatvoering(Object o) {
        Maatvoering mv = new Maatvoering();
        MaatvoeringType ebt = (MaatvoeringType)o;
        String identificatie = this.getIdentificatie(ebt.getIdentificatie());
        mv.setIdentificatie(identificatie);
        mv.setNaam(ebt.getNaam());
        mv.setTypePlanObject(ebt.getTypePlanobject().value());
        mv.setVerwijzing(ebt.getVerwijzingNaarObjectgerichteTekst());
        for (WaardeEnTypePropertyType maatvoeringInfo : ebt.getMaatvoeringInfo()) {
            WaardeEnTypeType wett = maatvoeringInfo.getWaardeEnType();
            WaardeEnType wet = new WaardeEnType(wett.getWaarde(), wett.getWaardeType(), wett.getWaarde(), mv);
            mv.getWaardeEnType().add(wet);
        }
        try {
            MultiPolygon g = gc.convertMultiPolygonGeometry(ebt.getPlangebied());
            mv.setGeometrie(g);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mv;
    }

    @Override
    public String getIdentificatie(Object id) {
        return (String)id;
    }

    @Override
    public Besluitvlak parseImroBesluitvlak(Object o) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        Besluitvlak bv = new Besluitvlak();
        BesluitvlakXType bvt = (BesluitvlakXType)o;
        String identificatie = this.getIdentificatie(bvt.getIdentificatie());
        bv.setIdentificatie(identificatie);
        bv.setNaam(bvt.getNaam().getValue());
        bv.setTypePlanObject(bvt.getTypePlanobject().value());
        bv.setVerwijzing(((TekstReferentieXGBPropertyType)bvt.getVerwijzingNaarTekstInfo().get(0)).getTekstReferentieXGB().getVerwijzingNaarTekst());
        MultiPolygon g = gc.convertMultiPolygonGeometry(bvt.getGeometrie());
        bv.setGeometrie(g);
        return bv;
    }

    @Override
    public Besluitgebied parseImroBesluitgebied(Object o) {
        Besluitgebied bg = new Besluitgebied();
        BesluitgebiedXType bgt = (BesluitgebiedXType)o;
        String identificatie = this.getIdentificatie(bgt.getIdentificatie());
        bg.setBeleidsmatigVerantwoordelijkeOverheid(bgt.getBeleidsmatigVerantwoordelijkeOverheid().value());
        bg.setBesluitnummer(bgt.getBesluitnummer());
        bg.setIdentificatie(identificatie);
        if (bgt.getLocatieNaam().size() > 0) {
            bg.setLocatieNaam((String)bgt.getLocatieNaam().get(0));
        }
        bg.setNaam(bgt.getNaam().getValue());
        bg.setNaamOverheid(bgt.getNaamOverheid());
        if (bgt.getNormadressant().size() > 0) {
            bg.setNormadressant(((NormadressantXGBType)bgt.getNormadressant().get(0)).value());
        }
        if (bgt.getOndergrond().size() > 0) {
            bg.setOndergrondInfo((String)bgt.getOndergrond().get(0));
        }
        bg.setOverheidsCode(bgt.getOverheidsCode());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        bg.setPlanstatus(bgt.getPlanstatusInfo().getPlanstatusEnDatumXGB().getPlanstatus().value());
        try {
            bg.setPlanstatusDatum(sdf.parse(bgt.getPlanstatusInfo().getPlanstatusEnDatumXGB().getDatum()));
        }
        catch (ParseException ex) {
            log.error((Object)"Cannot parse date: ", (Throwable)ex);
        }
        bg.setTypePlan(bgt.getTypePlan().value());
        if (bgt.getVerwijzingNaarExternPlanInfo().size() > 0) {
            bg.setVerwijzingNaarExternPlanInfo(((ExternPlanReferentieXGBPropertyType)bgt.getVerwijzingNaarExternPlanInfo().get(0)).getExternPlanReferentieXGB().getNaamExternPlan());
        }
        if (bgt.getVerwijzingNaarIllustratieInfo().size() > 0) {
            bg.setVerwijzingNaarIllustratieInfo(((IllustratieReferentieXGBPropertyType)bgt.getVerwijzingNaarIllustratieInfo().get(0)).getIllustratieReferentieXGB().getVerwijzingNaarIllustratie());
        }
        if (bgt.getVerwijzingNaarTekstInfo().size() > 0) {
            bg.setVerwijzingNaarTekstInfo(((TekstReferentieBGXGBPropertyType)bgt.getVerwijzingNaarTekstInfo().get(0)).getTekstReferentieBGXGB().getVerwijzingNaarTekst());
        }
        bg.setVerwijzingNaarVaststellingsbesluit(bgt.getVerwijzingNaarVaststellingsbesluit());
        if (bgt.getVerwijzingNorm().size() > 0) {
            bg.setVerwijzingNorm((String)bgt.getVerwijzingNorm().get(0));
        }
        try {
            MultiPolygon g = gc.convertMultiPolygonGeometry(bgt.getGeometrie());
            bg.setGeometrie(g);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bg;
    }

    @Override
    public Besluitsubvlak parseImroBesluitsubvlak(Object o) throws IOException, ParserConfigurationException, SAXException, TransformerException, NoSuchMethodException {
        Besluitsubvlak bsv = new Besluitsubvlak();
        BesluitsubvlakXType bs = (BesluitsubvlakXType)o;
        String identificatie = bs.getIdentificatie();
        bsv.setIdentificatie(identificatie);
        bsv.setNaam(bs.getNaam().getValue());
        MultiPolygon g = gc.convertMultiPolygonGeometry(bs.getGeometrie());
        bsv.setGeometrie(g);
        bsv.setTypePlanObject(bs.getTypePlanobject().value());
        if (bs.getVerwijzingNaarTekstInfo().size() > 0) {
            bsv.setVerwijzing(((TekstReferentieXGBPropertyType)bs.getVerwijzingNaarTekstInfo().get(0)).getTekstReferentieXGB().getVerwijzingNaarTekst());
        }
        for (BesluitvlakXPropertyType besluitvlak : bs.getBesluitvlak()) {
            bsv.getBesluitvlakken().add(besluitvlak.getHref().substring(1));
        }
        for (BesluitsubvlakXPropertyType besluitsubvlak : bs.getBesluitsubvlak()) {
            bsv.getBesluitsubvlakken().add(besluitsubvlak.getHref().substring(1));
        }
        return bsv;
    }
}

