/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.imro.harvester.processing;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StatusReport {
    private int plansProcessed = 0;
    private boolean wasFatal = false;
    private List<String> plansErrored = new ArrayList();
    private List<String> loadedPlans = new ArrayList();
    private Map<String, Integer> skipped = new HashMap();
    private String log = "";

    public void addProcessed() {
        ++this.plansProcessed;
    }

    public void addSkipped(String reason) {
        if (!this.skipped.containsKey(reason)) {
            this.skipped.put(reason, 0);
        }
        this.skipped.put(reason, (Integer)this.skipped.get(reason) + 1);
    }

    public void addLoaded(String plan) {
        this.loadedPlans.add(plan);
    }

    public void addErrored(String plan, Exception log) {
        this.plansErrored.add(plan);
        StringWriter sw = new StringWriter();
        log.printStackTrace(new PrintWriter(sw));
        String exceptionAsString = sw.toString();
        this.log = this.log + "<br/>";
        this.log = this.log + plan + "<br/>";
        this.log = this.log + exceptionAsString;
    }

    public void addFatal(String log) {
        this.log = this.log + log;
        this.wasFatal = true;
    }

    public int getPlansProcessed() {
        return this.plansProcessed;
    }

    public int getNumPlansSkipped() {
        return this.skipped.size();
    }

    public String getLog() {
        String logString = "Totaal plannen in manifest: " + this.plansProcessed + "<br/>";
        logString = logString + "Aantal plannen ingeladen: " + this.loadedPlans.size() + "<br/>";
        int total = 0;
        for (String key : this.skipped.keySet()) {
            total += ((Integer)this.skipped.get(key)).intValue();
            logString = logString + "Aantal plannen overgeslagen met reden: " + key + " : " + this.skipped.get(key) + "<br/>";
        }
        logString = logString + "Totaal aantal plannen overgeslagen: " + total + "<br/>";
        logString = logString + "Aantal plannen mislukt: " + this.plansErrored.size() + "<br/>";
        logString = logString + "<hr/> Plannen die fout gegaan zijn: <br/>";
        if (this.plansErrored.size() > 0) {
            for (String plan : this.plansErrored) {
                logString = logString + plan + "<br/>";
            }
        }
        logString = logString + "<hr/> Foutmeldingen: <br/>";
        logString = logString + this.log;
        return logString;
    }

    public void setLog(String log) {
        this.log = log;
    }

    public boolean wasFatal() {
        return this.wasFatal;
    }

    public List<String> getPlansErrored() {
        return this.plansErrored;
    }

    public List<String> getLoadedPlans() {
        return this.loadedPlans;
    }
}

