/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.imro.harvester.parser;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import nl.b3p.imro.harvester.parser.Geleideformulier;
import nl.b3p.imro.harvester.parser.STRIParser;
import nl.b3p.imro.harvester.processing.HarvesterInitializer;
import nl.b3p.imro.harvester.processing.StatusReport;
import nl.b3p.stri._2008._1.GeleideFormulier;
import nl.b3p.stri._2008._1.Manifest;
import nl.b3p.stri._2008._1.Plan;

public class STRIParser2008
implements STRIParser {
    private final JAXBContext jaxbSTRIContext = JAXBContext.newInstance((String)"nl.b3p.stri._2008._1");

    @Override
    public List<URL> getGeleideformulierURLSFromManifest(URL manifestURL) throws JAXBException, MalformedURLException {
        ArrayList<URL> geleideformulieren = new ArrayList<URL>();
        Unmarshaller jaxbUnmarshaller = this.jaxbSTRIContext.createUnmarshaller();
        Manifest manifest = (Manifest)jaxbUnmarshaller.unmarshal(manifestURL);
        List plannen = manifest.getPlan();
        for (Plan plan : plannen) {
            geleideformulieren.add(new URL(plan.getOnderdelen().getBasisURL() + plan.getOnderdelen().getGeleideFormulier()));
        }
        return geleideformulieren;
    }

    @Override
    public List<Geleideformulier> retrieveGeleideformulieren(List<URL> geleideformulieren, StatusReport report) throws MalformedURLException, JAXBException {
        ArrayList<Geleideformulier> formulieren = new ArrayList<Geleideformulier>();
        Unmarshaller jaxbUnmarshaller = this.jaxbSTRIContext.createUnmarshaller();
        for (URL formulierURL : geleideformulieren) {
            GeleideFormulier striGeleideform = (GeleideFormulier)jaxbUnmarshaller.unmarshal(formulierURL);
            Plan plan = striGeleideform.getPlan();
            Plan.Eigenschappen eigenschappen = plan.getEigenschappen();
            if (eigenschappen.getType() != null && HarvesterInitializer.canProcessPlantype(eigenschappen.getType().value())) {
                Geleideformulier geleideformulier = new Geleideformulier();
                Plan.Onderdelen onderdelen = plan.getOnderdelen();
                Plan.Supplementen supplementen = plan.getSupplementen();
                String identificatie = plan.getId();
                String basisURL = onderdelen.getBasisURL();
                geleideformulier.setIdentificatie(identificatie);
                geleideformulier.setNaam(eigenschappen.getNaam());
                geleideformulier.setType(eigenschappen.getType().value());
                geleideformulier.setStatus(eigenschappen.getStatus().value());
                geleideformulier.setDatum(eigenschappen.getDatum().toString());
                geleideformulier.setVersie(eigenschappen.getVersieIMRO());
                geleideformulier.setBasisURL(basisURL);
                geleideformulier.setImro(onderdelen.getIMRO());
                for (String regel : onderdelen.getRegels()) {
                    geleideformulier.getBijlages().add(new URL(basisURL + regel));
                }
                for (String regelsBijlage : onderdelen.getRegelsBijlage()) {
                    geleideformulier.getBijlages().add(new URL(basisURL + regelsBijlage));
                }
                for (String toelichting : onderdelen.getToelichting()) {
                    geleideformulier.getBijlages().add(new URL(basisURL + toelichting));
                }
                for (String toelichtingBijlage : onderdelen.getToelichtingBijlage()) {
                    geleideformulier.getBijlages().add(new URL(basisURL + toelichtingBijlage));
                }
                if (onderdelen.getGeleideFormulier() != null) {
                    geleideformulier.getBijlages().add(new URL(basisURL + onderdelen.getGeleideFormulier()));
                }
                if (onderdelen.getVaststellingsBesluit() != null) {
                    geleideformulier.getBijlages().add(new URL(basisURL + onderdelen.getVaststellingsBesluit()));
                }
                if (onderdelen.getPlanTeksten() != null) {
                    geleideformulier.getBijlages().add(new URL(basisURL + onderdelen.getPlanTeksten()));
                }
                for (String beleidsDocument : onderdelen.getBeleidsDocument()) {
                    geleideformulier.getBijlages().add(new URL(basisURL + beleidsDocument));
                }
                for (String beleidsDocumentBijlage : onderdelen.getBeleidsDocumentBijlage()) {
                    geleideformulier.getBijlages().add(new URL(basisURL + beleidsDocumentBijlage));
                }
                if (onderdelen.getBesluitDocument() != null) {
                    geleideformulier.getBijlages().add(new URL(basisURL + onderdelen.getBesluitDocument()));
                }
                for (String besldocbijl : onderdelen.getBesluitDocumentBijlage()) {
                    geleideformulier.getBijlages().add(new URL(basisURL + besldocbijl));
                }
                for (String beleidsTekst : onderdelen.getBeleidsTekst()) {
                    geleideformulier.getBijlages().add(new URL(basisURL + beleidsTekst));
                }
                for (String beleidsTekstBijlage : onderdelen.getBeleidsTekstBijlage()) {
                    geleideformulier.getBijlages().add(new URL(basisURL + beleidsTekstBijlage));
                }
                for (String illustratie : onderdelen.getIllustratie()) {
                    geleideformulier.getBijlages().add(new URL(basisURL + illustratie));
                }
                geleideformulier.getBijlages().add(new URL(basisURL + onderdelen.getIMRO()));
                formulieren.add(geleideformulier);
                continue;
            }
            String message = "Type niet ondersteund: " + eigenschappen.getType();
            if (eigenschappen.getType() != null) {
                message = message + " - " + eigenschappen.getType().value();
                report.addSkipped(message);
                throw new IllegalArgumentException(message);
            }
            IllegalArgumentException e = new IllegalArgumentException(message);
            report.addErrored(plan.getId(), e);
            throw e;
        }
        return formulieren;
    }
}

