/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.imro.harvester.parser;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import nl.b3p.imro.harvester.parser.Geleideformulier;
import nl.b3p.imro.harvester.parser.STRIParser;
import nl.b3p.imro.harvester.processing.HarvesterInitializer;
import nl.b3p.imro.harvester.processing.StatusReport;
import nl.geonovum.stri._2012._1.Dossier;
import nl.geonovum.stri._2012._1.GeleideFormulier;
import nl.geonovum.stri._2012._1.Plan;
import nl.geonovum.stri._2012._2.Dossier;
import nl.geonovum.stri._2012._2.Manifest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class STRIParser2012
implements STRIParser {
    private static final Log log = LogFactory.getLog(STRIParser2012.class);
    private final JAXBContext jaxbSTRIContext = JAXBContext.newInstance((Class[])new Class[]{GeleideFormulier.class, nl.geonovum.stri._2012._2.GeleideFormulier.class, nl.geonovum.stri._2012._1.Manifest.class, Manifest.class});

    @Override
    public List<URL> getGeleideformulierURLSFromManifest(URL manifestUrl) throws JAXBException, MalformedURLException {
        ArrayList<URL> geleideformulieren = new ArrayList<URL>();
        Unmarshaller jaxbUnmarshaller = this.jaxbSTRIContext.createUnmarshaller();
        Object m = jaxbUnmarshaller.unmarshal(manifestUrl);
        if (m instanceof nl.geonovum.stri._2012._1.Manifest) {
            nl.geonovum.stri._2012._1.Manifest manifest = (nl.geonovum.stri._2012._1.Manifest)m;
            List dossiers = manifest.getDossier();
            for (Dossier dossier : dossiers) {
                List plannen = dossier.getPlan();
                for (Dossier.Plan plan : plannen) {
                    geleideformulieren.add(new URL(plan.getGeleideFormulier()));
                }
            }
        } else if (m instanceof Manifest) {
            Manifest manifest = (Manifest)m;
            List dossiers = manifest.getDossier();
            for (nl.geonovum.stri._2012._2.Dossier dossier : dossiers) {
                List plannen = dossier.getPlan();
                for (Dossier.Plan plan : plannen) {
                    geleideformulieren.add(new URL(plan.getGeleideFormulier()));
                }
            }
        } else {
            log.error((Object)("Manifest of unknown version. Object: " + m.getClass()));
        }
        return geleideformulieren;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Geleideformulier> retrieveGeleideformulieren(List<URL> geleideformulieren, StatusReport report) throws MalformedURLException, JAXBException {
        ArrayList<Geleideformulier> urls = new ArrayList<Geleideformulier>();
        Unmarshaller jaxbUnmarshaller = this.jaxbSTRIContext.createUnmarshaller();
        Iterator<URL> iterator = geleideformulieren.iterator();
        while (iterator.hasNext()) {
            URL geleideformulierURL = iterator.next();
            try {
                Iterator bijlage2;
                String gml;
                String basisurl;
                Plan.Onderdelen onderdelen;
                Plan.Eigenschappen eigenschappen;
                GeleideFormulier gf;
                Geleideformulier geleideformulier = null;
                Object geleideformulierObject = jaxbUnmarshaller.unmarshal(geleideformulierURL);
                if (geleideformulierObject instanceof GeleideFormulier) {
                    gf = (GeleideFormulier)geleideformulierObject;
                    eigenschappen = gf.getPlan().getEigenschappen();
                    if (!HarvesterInitializer.canProcessPlantype(eigenschappen.getType().value())) {
                        report.addSkipped("Type niet ondersteund: " + eigenschappen.getType().value());
                        throw new IllegalArgumentException("Type onbekend: " + eigenschappen.getType());
                    }
                    geleideformulier = new Geleideformulier();
                    onderdelen = gf.getPlan().getOnderdelen();
                    basisurl = onderdelen.getBasisURL();
                    gml = onderdelen.getIMRO();
                    geleideformulier.getBijlages().add(new URL(basisurl + gml));
                    if (onderdelen.getRegels() != null) {
                        geleideformulier.getBijlages().add(new URL(basisurl + onderdelen.getRegels()));
                    }
                    if (onderdelen.getToelichting() != null) {
                        geleideformulier.getBijlages().add(new URL(basisurl + onderdelen.getToelichting()));
                    }
                    if (onderdelen.getGeleideFormulier() != null) {
                        geleideformulier.getBijlages().add(new URL(basisurl + onderdelen.getGeleideFormulier()));
                    }
                    if (onderdelen.getVaststellingsBesluit() != null) {
                        geleideformulier.getBijlages().add(new URL(basisurl + onderdelen.getVaststellingsBesluit()));
                    }
                    if (onderdelen.getPlanTeksten() != null) {
                        geleideformulier.getBijlages().add(new URL(basisurl + onderdelen.getPlanTeksten()));
                    }
                    if (onderdelen.getBeleidsOfBesluitDocument() != null) {
                        geleideformulier.getBijlages().add(new URL(basisurl + onderdelen.getBeleidsOfBesluitDocument()));
                    }
                    List bijlages = onderdelen.getBijlage();
                    for (Iterator bijlage2 : bijlages) {
                        geleideformulier.getBijlages().add(new URL(basisurl + bijlage2));
                    }
                    List illustraties = onderdelen.getIllustratie();
                    bijlage2 = illustraties.iterator();
                    while (bijlage2.hasNext()) {
                        String illustratie = (String)bijlage2.next();
                        geleideformulier.getBijlages().add(new URL(basisurl + illustratie));
                    }
                    geleideformulier.setIdentificatie(gf.getPlan().getId());
                    geleideformulier.setBasisURL(basisurl);
                    geleideformulier.setDatum(eigenschappen.getDatum().toString());
                    geleideformulier.setNaam(eigenschappen.getNaam());
                    geleideformulier.setStatus(eigenschappen.getStatus().value());
                    geleideformulier.setVersie(eigenschappen.getVersieIMRO());
                    geleideformulier.setType(eigenschappen.getType().value());
                    geleideformulier.setImro(onderdelen.getIMRO());
                } else if (geleideformulierObject instanceof nl.geonovum.stri._2012._2.GeleideFormulier) {
                    gf = (nl.geonovum.stri._2012._2.GeleideFormulier)geleideformulierObject;
                    eigenschappen = gf.getPlan().getEigenschappen();
                    if (!HarvesterInitializer.canProcessPlantype(eigenschappen.getType().value())) {
                        report.addSkipped("Type niet ondersteund: " + eigenschappen.getType().value());
                        throw new IllegalArgumentException("Type onbekend: " + eigenschappen.getType());
                    }
                    geleideformulier = new Geleideformulier();
                    onderdelen = gf.getPlan().getOnderdelen();
                    basisurl = onderdelen.getBasisURL();
                    gml = onderdelen.getGML();
                    URL u = new URL(basisurl + gml);
                    geleideformulier.getBijlages().add(new URL(basisurl + gml));
                    if (onderdelen.getRegels() != null) {
                        geleideformulier.getBijlages().add(new URL(basisurl + onderdelen.getRegels()));
                    }
                    if (onderdelen.getToelichting() != null) {
                        geleideformulier.getBijlages().add(new URL(basisurl + onderdelen.getToelichting()));
                    }
                    if (onderdelen.getGeleideFormulier() != null) {
                        geleideformulier.getBijlages().add(new URL(basisurl + onderdelen.getGeleideFormulier()));
                    }
                    if (onderdelen.getVaststellingsBesluit() != null) {
                        geleideformulier.getBijlages().add(new URL(basisurl + onderdelen.getVaststellingsBesluit()));
                    }
                    if (onderdelen.getPlanTeksten() != null) {
                        geleideformulier.getBijlages().add(new URL(basisurl + onderdelen.getPlanTeksten()));
                    }
                    if (onderdelen.getBeleidsOfBesluitDocument() != null) {
                        geleideformulier.getBijlages().add(new URL(basisurl + onderdelen.getBeleidsOfBesluitDocument()));
                    }
                    List bijlages = onderdelen.getBijlage();
                    bijlage2 = bijlages.iterator();
                    while (bijlage2.hasNext()) {
                        String bijlage3 = (String)bijlage2.next();
                        geleideformulier.getBijlages().add(new URL(basisurl + bijlage3));
                    }
                    List illustraties = onderdelen.getIllustratie();
                    for (String illustratie : illustraties) {
                        geleideformulier.getBijlages().add(new URL(basisurl + illustratie));
                    }
                    geleideformulier.setIdentificatie(gf.getPlan().getId());
                    geleideformulier.setBasisURL(basisurl);
                    geleideformulier.setDatum(eigenschappen.getDatum().toString());
                    geleideformulier.setNaam(eigenschappen.getNaam());
                    geleideformulier.setStatus(eigenschappen.getStatus().value());
                    geleideformulier.setVersie(eigenschappen.getVersieGML());
                    geleideformulier.setType(eigenschappen.getType().value());
                    geleideformulier.setImro(onderdelen.getGML());
                }
                if (geleideformulier == null) continue;
                urls.add(geleideformulier);
            }
            catch (JAXBException ex) {
                log.debug((Object)("Cannot unmarshal geleideformulier" + geleideformulierURL));
                continue;
            }
            break;
        }
        return urls;
    }
}

