/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.imro.harvester.stripes;

import java.io.File;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.After;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.SimpleError;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidationError;
import nl.b3p.imro.harvester.entities.Configuration;
import nl.b3p.imro.harvester.processing.HarvesterInitializer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronExpression;
import org.quartz.SchedulerException;
import org.stripesstuff.stripersist.Stripersist;

@StrictBinding
@UrlBinding(value="/action/beheer/admin/{event}")
public class AdminActionBean
implements ActionBean {
    protected static final Log log = LogFactory.getLog(AdminActionBean.class);
    private ActionBeanContext context;
    public static final String CONFIG_CRON = "cronexpression";
    public static final String CONFIG_DOWNLOADFOLDER = "download.folder";
    private final String JSP_VIEW = "/WEB-INF/jsp/admin/view.jsp";
    private Configuration downloadConfig;
    private Configuration cronConfig;
    @Validate
    private String cron;
    @Validate
    private String downloadfolder;

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public String getCron() {
        return this.cron;
    }

    public void setCron(String cron) {
        this.cron = cron;
    }

    public String getDownloadfolder() {
        return this.downloadfolder;
    }

    public void setDownloadfolder(String downloadfolder) {
        this.downloadfolder = downloadfolder;
    }

    @DefaultHandler
    public Resolution view() {
        return new ForwardResolution("/WEB-INF/jsp/admin/view.jsp");
    }

    public Resolution save() {
        EntityManager em = Stripersist.getEntityManager();
        if (this.cron != null) {
            if (CronExpression.isValidExpression((String)this.cron)) {
                Configuration cronConfig = null;
                try {
                    cronConfig = (Configuration)em.createQuery("FROM Configuration WHERE key = :cronKey", Configuration.class).setParameter("cronKey", (Object)CONFIG_CRON).getSingleResult();
                }
                catch (NoResultException e) {
                    cronConfig = new Configuration();
                    cronConfig.setKey(CONFIG_CRON);
                }
                cronConfig.setValue(this.cron);
                em.persist((Object)cronConfig);
                try {
                    HarvesterInitializer.updateTrigger((String)this.cron);
                }
                catch (SchedulerException ex) {
                    log.error((Object)"Could not update trigger. ", (Throwable)ex);
                    this.context.getValidationErrors().add("cron", (ValidationError)new SimpleError("Is opgeslagen, maar niet actief.", new Object[0]));
                }
                this.context.getMessages().add(new SimpleMessage("Cronexpressie opgeslagen.", new Object[0]));
                try {
                    this.context.getMessages().add(new SimpleMessage("Volgende uitvoertijd: " + HarvesterInitializer.getNextExecutionTime(), new Object[0]));
                }
                catch (SchedulerException ex) {
                    log.error((Object)"Kan volgende uitvoertijd niet ophalen: ", (Throwable)ex);
                }
            } else {
                this.context.getValidationErrors().add("cron", (ValidationError)new SimpleError("De cronexpressie is niet correct. Zie ook <a href='https://en.wikipedia.org/wiki/Cron#Configuration_file'>hier</a>", new Object[0]));
            }
        }
        if (this.downloadfolder != null) {
            File f = new File(this.downloadfolder);
            if (f.exists() && f.isDirectory()) {
                Configuration downloadConfig = null;
                try {
                    downloadConfig = (Configuration)em.createQuery("FROM Configuration WHERE key = :downloadKey", Configuration.class).setParameter("downloadKey", (Object)CONFIG_DOWNLOADFOLDER).getSingleResult();
                }
                catch (NoResultException e) {
                    downloadConfig = new Configuration();
                    downloadConfig.setKey(CONFIG_DOWNLOADFOLDER);
                }
                downloadConfig.setValue(this.downloadfolder);
                em.persist((Object)downloadConfig);
                HarvesterInitializer.setDownloadFolder((File)f);
                this.context.getMessages().add(new SimpleMessage("Downloadfolder opgeslagen", new Object[0]));
            } else {
                this.context.getValidationErrors().add("downloadfolder", (ValidationError)new SimpleError("Download folder bestaat niet of is geen folder.", new Object[0]));
            }
        }
        em.getTransaction().commit();
        return new ForwardResolution("/WEB-INF/jsp/admin/view.jsp");
    }

    @After(stages={LifecycleStage.EventHandling})
    private void initVars() {
        EntityManager em = Stripersist.getEntityManager();
        try {
            this.cronConfig = (Configuration)em.createQuery("FROM Configuration WHERE key = :cronKey", Configuration.class).setParameter("cronKey", (Object)CONFIG_CRON).getSingleResult();
            this.cron = this.cronConfig.getValue();
        }
        catch (NoResultException e) {
            this.cronConfig = new Configuration();
            this.cronConfig.setKey(CONFIG_CRON);
        }
        try {
            this.downloadConfig = (Configuration)em.createQuery("FROM Configuration WHERE key = :downloadKey", Configuration.class).setParameter("downloadKey", (Object)CONFIG_DOWNLOADFOLDER).getSingleResult();
            this.downloadfolder = this.downloadConfig.getValue();
        }
        catch (NoResultException e) {
            this.downloadConfig = new Configuration();
            this.downloadConfig.setKey(CONFIG_DOWNLOADFOLDER);
        }
    }
}

