/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.imro.harvester.parser;

import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import nl.b3p.imro._2006._1.BesluitgebiedType;
import nl.b3p.imro._2006._1.BestemmingsfunctieElementPropertyType;
import nl.b3p.imro._2006._1.BestemmingsplangebiedType;
import nl.b3p.imro._2006._1.BestemmingsvlakPropertyType;
import nl.b3p.imro._2006._1.BouwvlakType;
import nl.b3p.imro._2006._1.DubbelbestemmingType;
import nl.b3p.imro._2006._1.EnkelbestemmingType;
import nl.b3p.imro._2006._1.FeatureCollectionType;
import nl.b3p.imro._2006._1.FeaturePropertyType;
import nl.b3p.imro._2006._1.FiguurType;
import nl.b3p.imro._2006._1.GebiedsaanduidingType;
import nl.b3p.imro._2006._1.LettertekenaanduidingType;
import nl.b3p.imro._2006._1.MaatvoeringType;
import nl.b3p.imro._2006._1.MatrixEnWaardePropertyType;
import nl.b3p.imro._2006._1.MatrixEnWaardeType;
import nl.b3p.imro._2006._1.MetadataIMRObestandType;
import nl.b3p.imro._2006._1.OmvangWaardeBPPropertyType;
import nl.b3p.imro._2006._1.OmvangWaardeBPType;
import nl.b3p.imro._2006._1.PuntLijnVlakPropertyType;
import nl.b3p.imro.harvester.entities.imro.Besluitgebied;
import nl.b3p.imro.harvester.entities.imro.Besluitsubvlak;
import nl.b3p.imro.harvester.entities.imro.Besluitvlak;
import nl.b3p.imro.harvester.entities.imro.Bestemmingsplan;
import nl.b3p.imro.harvester.entities.imro.Bouwaanduiding;
import nl.b3p.imro.harvester.entities.imro.Bouwvlak;
import nl.b3p.imro.harvester.entities.imro.Dubbelbestemming;
import nl.b3p.imro.harvester.entities.imro.Enkelbestemming;
import nl.b3p.imro.harvester.entities.imro.Figuur;
import nl.b3p.imro.harvester.entities.imro.Functieaanduiding;
import nl.b3p.imro.harvester.entities.imro.Gebiedsaanduiding;
import nl.b3p.imro.harvester.entities.imro.Maatvoering;
import nl.b3p.imro.harvester.entities.imro.WaardeEnType;
import nl.b3p.imro.harvester.parser.Geleideformulier;
import nl.b3p.imro.harvester.parser.IMROParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class IMROParser2006
implements IMROParser {
    protected static final Log log = LogFactory.getLog(IMROParser2006.class);
    private JAXBContext context = JAXBContext.newInstance((String)"nl.b3p.imro._2006._1");

    public List<Object> parseGML(Geleideformulier geleideformulier) throws JAXBException, URISyntaxException, MalformedURLException, IOException, ParserConfigurationException, SAXException, TransformerException {
        return this.parseGML(geleideformulier.getGML());
    }

    public List<Object> parseGML(URL u) throws JAXBException, IOException, ParserConfigurationException, SAXException, TransformerException, URISyntaxException {
        Object value = this.unmarshalUrl(u);
        List bp = this.processFeatureCollection(value);
        return bp;
    }

    public Object unmarshalUrl(URL u) throws JAXBException, IOException, URISyntaxException {
        Unmarshaller jaxbUnmarshaller = this.context.createUnmarshaller();
        JAXBElement o = (JAXBElement)this.retrieveXMLObjectFromURL(u, jaxbUnmarshaller);
        Object value = o.getValue();
        return value;
    }

    public List<Object> processFeatureCollection(Object featureCollection) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        FeatureCollectionType fc = (FeatureCollectionType)featureCollection;
        ArrayList<Object> objs = new ArrayList<Object>();
        List members = fc.getFeatureMember();
        for (FeaturePropertyType member : members) {
            Object o = member.getFeature().getValue();
            Object parsed = this.parseFeatureMember(o);
            if (parsed == null) continue;
            objs.add(parsed);
        }
        return objs;
    }

    public Object parseFeatureMember(Object o) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        Gebiedsaanduiding obj = null;
        if (o instanceof GebiedsaanduidingType) {
            obj = this.parseImroGebiedsaanduiding(o);
        } else if (o instanceof BestemmingsplangebiedType) {
            obj = this.parseImroBestemmingsplan(o);
        } else if (o instanceof DubbelbestemmingType) {
            obj = this.parseImroDubbelbestemming(o);
        } else if (o instanceof EnkelbestemmingType) {
            obj = this.parseImroEnkelbestemming(o);
        } else if (o instanceof MaatvoeringType) {
            obj = this.parseImroMaatvoering(o);
        } else if (o instanceof BouwvlakType) {
            obj = this.parseImroBouwvlak(o);
        } else if (o instanceof LettertekenaanduidingType) {
            obj = this.parseImroFunctieaanduiding(o);
        } else if (o instanceof FiguurType) {
            obj = this.parseImroFiguur(o);
        } else if (o instanceof BesluitgebiedType) {
            obj = this.parseImroBesluitgebied(o);
        } else if (!(o instanceof MetadataIMRObestandType)) {
            log.error((Object)("Unknown type of featuremember when parsing. Class encountered: " + o.getClass().toString()));
        }
        return obj;
    }

    public Bestemmingsplan parseImroBestemmingsplan(Object o) {
        Bestemmingsplan bp = new Bestemmingsplan();
        BestemmingsplangebiedType bpgt = (BestemmingsplangebiedType)o;
        String identificatie = this.getIdentificatie((Object)bpgt.getIdentificatie());
        bp.setTypePlan(bpgt.getTypePlan().value());
        bp.setIdentificatie(identificatie);
        bp.setNaam(bpgt.getNaam().getValue());
        if (bpgt.getLocatieNaam().size() > 0) {
            bp.setLocatieNaam((String)bpgt.getLocatieNaam().get(0));
        }
        if (!bpgt.getWoonplaatsNaam().isEmpty()) {
            bp.setNaamOverheid((String)bpgt.getWoonplaatsNaam().get(0));
        }
        bp.setOverheidsCode(bpgt.getGemeenteCode());
        bp.setPlanstatusInfo(bpgt.getPlanstatusInfo().getPlanstatusBPenDatum().getPlanstatus().value());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            bp.setPlanstatusDatum(sdf.parse(bpgt.getPlanstatusInfo().getPlanstatusBPenDatum().getDatum()));
        }
        catch (ParseException ex) {
            log.debug((Object)("Cannot parse datestring: " + bpgt.getPlanstatusInfo().getPlanstatusBPenDatum().getDatum()), (Throwable)ex);
        }
        bp.setTypePlan(bpgt.getTypePlan().value());
        try {
            MultiPolygon g = gc.convertMultiPolygonGeometry(bpgt.getGeometrie());
            bp.setGeometrie(g);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bp;
    }

    public Dubbelbestemming parseImroDubbelbestemming(Object o) {
        Dubbelbestemming db = new Dubbelbestemming();
        DubbelbestemmingType dbt = (DubbelbestemmingType)o;
        String identificatie = this.getIdentificatie((Object)dbt.getIdentificatie());
        db.setArtikelnummer(dbt.getArtikelnummer());
        db.setBestemmingshoofdgroep(dbt.getBestemmingshoofdgroep().value());
        db.setIdentificatie(identificatie);
        db.setNaam(dbt.getNaam().getValue());
        db.setTypePlanObject(dbt.getTypePlanobject().value());
        if (!dbt.getVerwijzingNaarTekst().isEmpty()) {
            db.setVerwijzing((String)dbt.getVerwijzingNaarTekst().get(0));
        }
        try {
            db.setGeometrie(this.getGeom(dbt.getGeometrie()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return db;
    }

    public Gebiedsaanduiding parseImroGebiedsaanduiding(Object o) {
        Gebiedsaanduiding gba = new Gebiedsaanduiding();
        GebiedsaanduidingType ga = (GebiedsaanduidingType)o;
        String identificatie = this.getIdentificatie((Object)ga.getIdentificatie());
        gba.setNaam(ga.getNaam().getValue());
        gba.setIdentificatie(identificatie);
        if (!ga.getArtikelnummer().isEmpty()) {
            gba.setArtikelnummer((String)ga.getArtikelnummer().get(0));
        }
        if (ga.getBestemmingsfunctieInfo().size() > 0) {
            gba.setGebiedsaanduidinggroep(((BestemmingsfunctieElementPropertyType)ga.getBestemmingsfunctieInfo().get(0)).getBestemmingsfunctieElement().getBestemmingsfunctie().value());
        }
        gba.setTypePlanObject(ga.getTypePlanobject().value());
        if (!ga.getVerwijzingNaarTekst().isEmpty()) {
            gba.setVerwijzing((String)ga.getVerwijzingNaarTekst().get(0));
        }
        try {
            MultiPolygon g = gc.convertMultiPolygonGeometry(ga.getGeometrie());
            gba.setGeometrie(g);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return gba;
    }

    public Bouwvlak parseImroBouwvlak(Object o) {
        Bouwvlak bv = new Bouwvlak();
        BouwvlakType bvt = (BouwvlakType)o;
        String identificatie = this.getIdentificatie((Object)bvt.getIdentificatie());
        bv.setIdentificatie(identificatie);
        bv.setNaam(bvt.getNaam().getValue());
        bv.setTypePlanObject(bvt.getTypePlanobject().value());
        BestemmingsvlakPropertyType bt = bvt.getBestemmingsvlak();
        bv.setEnkelbestemming(bt.getHref().substring(1));
        try {
            MultiPolygon g = gc.convertMultiPolygonGeometry(bvt.getGeometrie());
            bv.setGeometrie(g);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bv;
    }

    public Functieaanduiding parseImroFunctieaanduiding(Object o) {
        Functieaanduiding fa = new Functieaanduiding();
        LettertekenaanduidingType fat = (LettertekenaanduidingType)o;
        String identificatie = this.getIdentificatie((Object)fat.getIdentificatie());
        fa.setIdentificatie(identificatie);
        fa.setNaam(fat.getNaam().getValue());
        fa.setTypePlanObject(fat.getTypePlanobject().value());
        if (fat.getBestemmingsvlak() != null) {
            BestemmingsvlakPropertyType bt = fat.getBestemmingsvlak();
            fa.setEnkelbestemming(bt.getHref().substring(1));
        }
        try {
            MultiPolygon g = gc.convertMultiPolygonGeometry(fat.getGeometrie());
            fa.setGeometrie(g);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fa;
    }

    public Figuur parseImroFiguur(Object o) {
        Figuur fa = new Figuur();
        FiguurType fat = (FiguurType)o;
        String identificatie = this.getIdentificatie((Object)fat.getIdentificatie());
        fa.setIdentificatie(identificatie);
        fa.setNaam(fat.getNaam().getValue());
        fa.setTypePlanObject(fat.getTypePlanobject().value());
        if (fat.getBestemmingsvlak() != null) {
            BestemmingsvlakPropertyType bt = fat.getBestemmingsvlak();
            fa.setEnkelbestemming(bt.getHref().substring(1));
        }
        try {
            MultiLineString g = gc.convertMultiLineStringGeometry(fat.getGeometrie());
            fa.setGeometrie(g);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fa;
    }

    public Bouwaanduiding parseImroBouwaanduiding(Object o) throws NoSuchMethodException {
        throw new NoSuchMethodException("Not available in IMRO2006");
    }

    public Enkelbestemming parseImroEnkelbestemming(Object o) {
        Enkelbestemming eb = new Enkelbestemming();
        EnkelbestemmingType ebt = (EnkelbestemmingType)o;
        String identificatie = this.getIdentificatie((Object)ebt.getIdentificatie());
        eb.setArtikelnummer(ebt.getArtikelnummer());
        eb.setBestemmingshoofdgroep(ebt.getBestemmingshoofdgroep().value());
        eb.setIdentificatie(identificatie);
        eb.setNaam(ebt.getNaam().getValue());
        eb.setTypePlanObject(ebt.getTypePlanobject().value());
        if (!ebt.getVerwijzingNaarTekst().isEmpty()) {
            eb.setVerwijzing((String)ebt.getVerwijzingNaarTekst().get(0));
        }
        try {
            eb.setGeometrie(this.getGeom(ebt.getGeometrie()));
        }
        catch (Exception e) {
            log.error((Object)"Fout parsing", (Throwable)e);
        }
        return eb;
    }

    public Maatvoering parseImroMaatvoering(Object o) {
        Maatvoering mv = new Maatvoering();
        MaatvoeringType ebt = (MaatvoeringType)o;
        String identificatie = this.getIdentificatie((Object)ebt.getIdentificatie());
        mv.setIdentificatie(identificatie);
        mv.setNaam(ebt.getNaam().getValue());
        mv.setTypePlanObject(ebt.getTypePlanobject().value());
        for (MatrixEnWaardePropertyType maatvoeringInfo : ebt.getMaatvoering()) {
            List values = ((MatrixEnWaardeType)maatvoeringInfo.getMatrixEnWaarde().getValue()).getOmvangWaarde();
            for (OmvangWaardeBPPropertyType value : values) {
                OmvangWaardeBPType omvangwaarde = value.getOmvangWaardeBP();
                WaardeEnType wet = new WaardeEnType(omvangwaarde.getWaarde(), omvangwaarde.getWaardeType(), omvangwaarde.getLabelInfo().getLabel().getTekst(), mv);
                mv.getWaardeEnType().add(wet);
            }
        }
        try {
            MultiPolygon g = gc.convertMultiPolygonGeometry(ebt.getGeometrie());
            mv.setGeometrie(g);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mv;
    }

    public String getIdentificatie(Object id) {
        return (String)id;
    }

    public Besluitvlak parseImroBesluitvlak(Object o) throws IOException, ParserConfigurationException, SAXException, TransformerException, NoSuchMethodException {
        throw new NoSuchMethodException("Besluitvlak does not exist in IMRO2006");
    }

    public Besluitgebied parseImroBesluitgebied(Object o) {
        Besluitgebied bg = new Besluitgebied();
        BesluitgebiedType bgt = (BesluitgebiedType)o;
        String identificatie = this.getIdentificatie((Object)bgt.getIdentificatie());
        bg.setBeleidsmatigVerantwoordelijkeOverheid(bgt.getOverheid().value());
        bg.setBesluitnummer(bgt.getBesluitnummer());
        bg.setIdentificatie(identificatie);
        bg.setLocatieNaam(bgt.getLocatieNaam());
        bg.setNaam(bgt.getNaam().getValue());
        bg.setNaamOverheid(bgt.getWoonplaatsNaam());
        bg.setNormadressant(bgt.getOntwerper());
        bg.setOverheidsCode(bgt.getGemeenteCode());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        bg.setPlanstatus(bgt.getStatusBeslissing().getPlanstatusBPenDatum().getPlanstatus().value());
        try {
            bg.setPlanstatusDatum(sdf.parse(bgt.getStatusBeslissing().getPlanstatusBPenDatum().getDatum()));
        }
        catch (ParseException ex) {
            log.error((Object)"Cannot parse date: ", (Throwable)ex);
        }
        bg.setTypePlan(bgt.getTypeBesluitgebied().value());
        if (bgt.getVerwijzingNaarExternPlan().size() > 0) {
            bg.setVerwijzingNaarExternPlanInfo((String)bgt.getVerwijzingNaarExternPlan().get(0));
        }
        if (bgt.getVerwijzingNaarTekst().size() > 0) {
            bg.setVerwijzingNaarTekstInfo((String)bgt.getVerwijzingNaarTekst().get(0));
        }
        if (bgt.getVerwijzingNorm().size() > 0) {
            bg.setVerwijzingNorm((String)bgt.getVerwijzingNorm().get(0));
        }
        try {
            MultiPolygon g = gc.convertMultiPolygonGeometry(bgt.getGeometrie());
            bg.setGeometrie(g);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bg;
    }

    private MultiPolygon getGeom(PuntLijnVlakPropertyType plv) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        Element el = null;
        if (plv.getPuntLijnVlak().getGeometrieLijn() != null) {
            el = (Element)plv.getPuntLijnVlak().getGeometrieLijn().getChildNodes().item(0);
        } else if (plv.getPuntLijnVlak().getGeometriePunt() != null) {
            el = (Element)plv.getPuntLijnVlak().getGeometriePunt().getChildNodes().item(0);
        } else if (plv.getPuntLijnVlak().getGeometrieVlak() != null) {
            el = (Element)plv.getPuntLijnVlak().getGeometrieVlak().getChildNodes().item(0);
        }
        if (el != null) {
            return gc.convertMultiPolygonGeometry(el);
        }
        return null;
    }

    public Besluitsubvlak parseImroBesluitsubvlak(Object o) throws IOException, ParserConfigurationException, SAXException, TransformerException, NoSuchMethodException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

