/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.imro.harvester.processing;

import java.io.File;
import java.util.List;
import javax.persistence.EntityManager;
import javax.xml.bind.JAXBException;
import nl.b3p.imro.harvester.processing.HarvesterInitializer;
import nl.b3p.imro.harvester.processing.Processor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom2.JDOMException;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.stripesstuff.stripersist.Stripersist;

public class JobExecutor
implements Job {
    private static final Log log = LogFactory.getLog(JobExecutor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext jec) throws JobExecutionException {
        JobDataMap data = jec.getJobDetail().getJobDataMap();
        File downloadfolder = HarvesterInitializer.getDownloadFolder();
        if (downloadfolder == null) {
            log.error((Object)"Download pad is niet geconfigureerd. Uitvoeren van jobs niet mogelijk.");
        } else {
            try {
                Stripersist.requestInit();
                EntityManager em = Stripersist.getEntityManager();
                if (!downloadfolder.exists()) {
                    downloadfolder = null;
                    log.error((Object)"Download pad bestaat niet. Uitvoeren van jobs niet mogelijk.");
                }
                List jobs = em.createQuery("FROM HarvestJob").getResultList();
                Processor p = new Processor(jobs, downloadfolder);
                p.process();
            }
            catch (JAXBException ex) {
                log.error((Object)"Cannot create processor: ", (Throwable)ex);
            }
            catch (JDOMException ex) {
                log.error((Object)"Cannot create processor: ", (Throwable)ex);
            }
            finally {
                Stripersist.requestComplete();
            }
        }
    }
}

