/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.imro.harvester.stripes;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.EntityManager;
import javax.xml.bind.JAXBException;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.After;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.SimpleError;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidateNestedProperties;
import net.sourceforge.stripes.validation.ValidationError;
import nl.b3p.imro.harvester.entities.HarvestJob;
import nl.b3p.imro.harvester.processing.HarvesterInitializer;
import nl.b3p.imro.harvester.processing.Processor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom2.JDOMException;
import org.quartz.JobKey;
import org.quartz.SchedulerException;
import org.stripesstuff.stripersist.Stripersist;

@StrictBinding
@UrlBinding(value="/action/beheer/jobs/{event}")
public class HarvestJobActionBean
implements ActionBean {
    protected static final Log log = LogFactory.getLog(HarvestJobActionBean.class);
    private ActionBeanContext context;
    private final String JSP_VIEW = "/WEB-INF/jsp/jobs/view.jsp";
    private final String JSP_LOG = "/WEB-INF/jsp/jobs/log.jsp";
    private final String JSP_EDIT = "/WEB-INF/jsp/jobs/edit.jsp";
    private List<HarvestJob> jobs = new ArrayList<HarvestJob>();
    private File downloadFolder = null;
    @Validate
    @ValidateNestedProperties(value={@Validate(field="url"), @Validate(field="type")})
    private HarvestJob job = new HarvestJob();
    private String nextExecutionTime;

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public List<HarvestJob> getJobs() {
        return this.jobs;
    }

    public void setJobs(List<HarvestJob> jobs) {
        this.jobs = jobs;
    }

    public HarvestJob getJob() {
        return this.job;
    }

    public void setJob(HarvestJob job) {
        this.job = job;
    }

    public File getDownloadFolder() {
        return this.downloadFolder;
    }

    public void setDownloadfolder(File downloadFolder) {
        this.downloadFolder = downloadFolder;
    }

    public String getNextExecutionTime() {
        return this.nextExecutionTime;
    }

    public void setNextExecutionTime(String nextExecutionTime) {
        this.nextExecutionTime = nextExecutionTime;
    }

    @Before
    public void init() {
        this.downloadFolder = HarvesterInitializer.getDownloadFolder();
        if (this.downloadFolder == null) {
            this.context.getValidationErrors().add("Pad", (ValidationError)new SimpleError("Download pad is niet geconfigureerd. Uitvoeren van jobs niet mogelijk.", new Object[0]));
        } else if (!this.downloadFolder.exists()) {
            this.downloadFolder = null;
            this.context.getValidationErrors().add("Pad", (ValidationError)new SimpleError("Download pad bestaat niet. Uitvoeren van jobs niet mogelijk.", new Object[0]));
        }
    }

    @DefaultHandler
    public Resolution view() {
        return new ForwardResolution("/WEB-INF/jsp/jobs/view.jsp");
    }

    public Resolution add() {
        return new ForwardResolution("/WEB-INF/jsp/jobs/edit.jsp");
    }

    public Resolution viewLog() {
        return new ForwardResolution("/WEB-INF/jsp/jobs/log.jsp");
    }

    public Resolution delete() {
        EntityManager em = Stripersist.getEntityManager();
        em.remove((Object)this.job);
        em.getTransaction().commit();
        return new ForwardResolution("/WEB-INF/jsp/jobs/view.jsp");
    }

    public Resolution save() {
        EntityManager em = Stripersist.getEntityManager();
        em.persist((Object)this.job);
        em.getTransaction().commit();
        return new ForwardResolution("/WEB-INF/jsp/jobs/view.jsp");
    }

    public Resolution edit() {
        return new ForwardResolution("/WEB-INF/jsp/jobs/edit.jsp");
    }

    public Resolution runSingle() throws JAXBException, JDOMException {
        Processor p = new Processor(Collections.singletonList(this.job), this.downloadFolder);
        p.process();
        return new ForwardResolution("/WEB-INF/jsp/jobs/view.jsp");
    }

    public Resolution runAll() throws JAXBException, JDOMException {
        try {
            HarvesterInitializer.getScheduler().triggerJob(new JobKey("harvestJobsExecutor", "harvestGroup"));
        }
        catch (SchedulerException ex) {
            this.context.getValidationErrors().add("Pad", (ValidationError)new SimpleError("Uitvoeren mislukt.", new Object[0]));
            log.error((Object)"Kan niet handmatig alle jobs uitvoeren: ", (Throwable)ex);
        }
        return new ForwardResolution("/WEB-INF/jsp/jobs/view.jsp");
    }

    @After(stages={LifecycleStage.EventHandling})
    private void createLists() {
        EntityManager em = Stripersist.getEntityManager();
        this.jobs = em.createQuery("From HarvestJob order by id", HarvestJob.class).getResultList();
        try {
            this.nextExecutionTime = HarvesterInitializer.getNextExecutionTime();
        }
        catch (SchedulerException ex) {
            log.error((Object)"Cannot get execution time: ", (Throwable)ex);
        }
    }
}

