
    create table public.besluitgebied (
        id  serial not null,
        beleidsmatig_verantwoordelijke_overheid varchar(255),
        besluitnummer varchar(255),
        geometrie geometry,
        identificatie varchar(255),
        locatie_naam varchar(255),
        naam varchar(255),
        naam_overheid varchar(255),
        normadressant varchar(255),
        ondergrond_info varchar(255),
        overheids_code varchar(255),
        planstatus varchar(255),
        planstatus_datum timestamp,
        type_plan varchar(255),
        verwijzing_naar_extern_plan_info varchar(255),
        verwijzing_naar_illustratie_info varchar(255),
        verwijzing_naar_tekst_info varchar(255),
        verwijzing_naar_vaststellingsbesluit varchar(255),
        verwijzing_norm varchar(255),
        primary key (id)
    );

    create table public.besluitsubvlak (
        id  serial not null,
        geometrie geometry,
        identificatie varchar(255),
        naam varchar(255),
        parent_identificatie varchar(255),
        type_plan_object varchar(255),
        verwijzing varchar(255),
        besluitgebied int4,
        primary key (id)
    );

    create table public.besluitsubvlak_besluitsubvlakken (
        besluitsubvlak int4 not null,
        besluitsubvlakken varchar(255)
    );

    create table public.besluitsubvlak_besluitvlakken (
        besluitsubvlak int4 not null,
        besluitvlakken varchar(255)
    );

    create table public.besluitvlak (
        id  serial not null,
        artikelnummer varchar(255),
        geometrie geometry,
        identificatie varchar(255),
        naam varchar(255),
        parent_identificatie varchar(255),
        type_plan_object varchar(255),
        verwijzing varchar(255),
        besluitgebied int4,
        primary key (id)
    );

    create table public.bestemmingsplan (
        id  serial not null,
        beleidsmatige_verantwoordelijke_overheid varchar(255),
        besluitnummer varchar(255),
        geometrie geometry,
        identificatie varchar(255),
        locatie_naam varchar(255),
        naam varchar(255),
        naam_overheid varchar(255),
        overheids_code varchar(255),
        planstatus_datum timestamp,
        planstatus_info varchar(255),
        type_plan varchar(255),
        primary key (id)
    );

    create table public.bouwaanduiding (
        id  serial not null,
        artikelnummer varchar(255),
        geometrie geometry,
        identificatie varchar(255),
        naam varchar(255),
        parent_identificatie varchar(255),
        type_plan_object varchar(255),
        verwijzing varchar(255),
        enkelbestemming varchar(255),
        bestemmingsplan int4,
        primary key (id)
    );

    create table public.bouwvlak (
        id  serial not null,
        artikelnummer varchar(255),
        geometrie geometry,
        identificatie varchar(255),
        naam varchar(255),
        parent_identificatie varchar(255),
        type_plan_object varchar(255),
        verwijzing varchar(255),
        enkelbestemming varchar(255),
        bestemmingsplan int4,
        primary key (id)
    );

    create table public.configuration (
        id  serial not null,
        key varchar(255),
        value varchar(255),
        primary key (id)
    );

    create table public.dubbelbestemming (
        id  serial not null,
        artikelnummer varchar(255),
        geometrie geometry,
        identificatie varchar(255),
        naam varchar(255),
        parent_identificatie varchar(255),
        type_plan_object varchar(255),
        verwijzing varchar(255),
        bestemmingshoofdgroep varchar(255),
        bestemmingsplan int4,
        primary key (id)
    );

    create table public.enkelbestemming (
        id  serial not null,
        artikelnummer varchar(255),
        geometrie geometry,
        identificatie varchar(255),
        naam varchar(255),
        parent_identificatie varchar(255),
        type_plan_object varchar(255),
        verwijzing varchar(255),
        bestemmingshoofdgroep varchar(255),
        bestemmingsplan int4,
        primary key (id)
    );

    create table public.figuur (
        id  serial not null,
        artikelnummer varchar(255),
        enkelbestemming varchar(255),
        geometrie geometry,
        identificatie varchar(255),
        naam varchar(255),
        parent_identificatie varchar(255),
        type_plan_object varchar(255),
        verwijzing varchar(255),
        bestemmingsplan int4,
        primary key (id)
    );

    create table public.functieaanduiding (
        id  serial not null,
        artikelnummer varchar(255),
        geometrie geometry,
        identificatie varchar(255),
        naam varchar(255),
        parent_identificatie varchar(255),
        type_plan_object varchar(255),
        verwijzing varchar(255),
        enkelbestemming varchar(255),
        bestemmingsplan int4,
        primary key (id)
    );

    create table public.gebiedsaanduiding (
        id  serial not null,
        artikelnummer varchar(255),
        geometrie geometry,
        identificatie varchar(255),
        naam varchar(255),
        parent_identificatie varchar(255),
        type_plan_object varchar(255),
        verwijzing varchar(255),
        gebiedsaanduidinggroep varchar(255),
        bestemmingsplan int4,
        primary key (id)
    );

    create table public.gebruiker (
        id  serial not null,
        password varchar(255),
        passwordhash varchar(255),
        passwordsalt varchar(255),
        username varchar(255),
        primary key (id)
    );

    create table public.gebruiker_roles (
        gebruiker int4 not null,
        role int4 not null,
        primary key (gebruiker, role)
    );

    create table public.harvest_job (
        id  serial not null,
        last_run_time timestamp,
        log text,
        status varchar(255),
        type varchar(255),
        url varchar(255),
        primary key (id)
    );

    create table public.maatvoering (
        id  serial not null,
        artikelnummer varchar(255),
        geometrie geometry,
        identificatie varchar(255),
        naam varchar(255),
        parent_identificatie varchar(255),
        type_plan_object varchar(255),
        verwijzing varchar(255),
        bestemmingsplan int4,
        primary key (id)
    );

    create table public.role (
        id int4 not null,
        role varchar(255),
        primary key (id)
    );

    create table public.waarde_en_type (
        id  serial not null,
        parent_identificatie varchar(255),
        symbool_code varchar(255),
        waarde varchar(255),
        waarde_type varchar(255),
        maatvoering int4,
        primary key (id)
    );

    alter table public.besluitsubvlak 
        add constraint FKEE3BE61C6A1F2F8A 
        foreign key (besluitgebied) 
        references public.besluitgebied;

    alter table public.besluitsubvlak_besluitsubvlakken 
        add constraint FK694B35560369FE 
        foreign key (besluitsubvlak) 
        references public.besluitsubvlak;

    alter table public.besluitsubvlak_besluitvlakken 
        add constraint FK39BEBF360369FE 
        foreign key (besluitsubvlak) 
        references public.besluitsubvlak;

    alter table public.besluitvlak 
        add constraint FKB542B4646A1F2F8A 
        foreign key (besluitgebied) 
        references public.besluitgebied;

    alter table public.bouwaanduiding 
        add constraint FK7446B7D72E0C68B0 
        foreign key (bestemmingsplan) 
        references public.bestemmingsplan;

    alter table public.bouwvlak 
        add constraint FK8272118F2E0C68B0 
        foreign key (bestemmingsplan) 
        references public.bestemmingsplan;

    alter table public.dubbelbestemming 
        add constraint FK250746D92E0C68B0 
        foreign key (bestemmingsplan) 
        references public.bestemmingsplan;

    alter table public.enkelbestemming 
        add constraint FK6356A5AA2E0C68B0 
        foreign key (bestemmingsplan) 
        references public.bestemmingsplan;

    alter table public.figuur 
        add constraint FKB4068B4E2E0C68B0 
        foreign key (bestemmingsplan) 
        references public.bestemmingsplan;

    alter table public.functieaanduiding 
        add constraint FK1EBD3342E0C68B0 
        foreign key (bestemmingsplan) 
        references public.bestemmingsplan;

    alter table public.gebiedsaanduiding 
        add constraint FK52BDBC172E0C68B0 
        foreign key (bestemmingsplan) 
        references public.bestemmingsplan;

    alter table public.gebruiker_roles 
        add constraint FK693FF394CBC5A7B3 
        foreign key (role) 
        references public.role;

    alter table public.gebruiker_roles 
        add constraint FK693FF3942E4AB245 
        foreign key (gebruiker) 
        references public.gebruiker;

    alter table public.maatvoering 
        add constraint FK5A784A552E0C68B0 
        foreign key (bestemmingsplan) 
        references public.bestemmingsplan;

    alter table public.waarde_en_type 
        add constraint FKAE20D20D65C13CA4 
        foreign key (maatvoering) 
        references public.maatvoering;
