
    create table besluitgebied (
       id  serial not null,
        beleidsmatig_verantwoordelijke_overheid varchar(255),
        besluitnummer varchar(255),
        geometrie bytea,
        identificatie varchar(255),
        locatie_naam varchar(255),
        naam varchar(255),
        naam_overheid varchar(255),
        normadressant varchar(255),
        ondergrond_info varchar(255),
        overheids_code varchar(255),
        planstatus varchar(255),
        planstatus_datum timestamp,
        type_plan varchar(255),
        verwijzing_naar_extern_plan_info varchar(255),
        verwijzing_naar_illustratie_info varchar(255),
        verwijzing_naar_tekst_info varchar(255),
        verwijzing_naar_vaststellingsbesluit varchar(255),
        verwijzing_norm varchar(255),
        primary key (id)
    );

    create table besluitsubvlak (
       id  serial not null,
        geometrie bytea,
        identificatie varchar(255),
        naam varchar(255),
        parent_identificatie varchar(255),
        type_plan_object varchar(255),
        verwijzing varchar(255),
        besluitgebied int4,
        primary key (id)
    );

    create table besluitsubvlak_besluitsubvlakken (
       besluitsubvlak int4 not null,
        besluitsubvlakken varchar(255)
    );

    create table besluitsubvlak_besluitvlakken (
       besluitsubvlak int4 not null,
        besluitvlakken varchar(255)
    );

    create table besluitvlak (
       id  serial not null,
        artikelnummer varchar(255),
        geometrie bytea,
        identificatie varchar(255),
        naam varchar(255),
        parent_identificatie varchar(255),
        type_plan_object varchar(255),
        verwijzing varchar(255),
        besluitgebied int4,
        primary key (id)
    );

    create table bestemmingsplan (
       id  serial not null,
        beleidsmatige_verantwoordelijke_overheid varchar(255),
        besluitnummer varchar(255),
        geometrie bytea,
        identificatie varchar(255),
        locatie_naam varchar(255),
        naam varchar(255),
        naam_overheid varchar(255),
        overheids_code varchar(255),
        planstatus_datum timestamp,
        planstatus_info varchar(255),
        type_plan varchar(255),
        primary key (id)
    );

    create table bouwaanduiding (
       id  serial not null,
        enkelbestemming varchar(255),
        primary key (id)
    );

    create table bouwvlak (
       id  serial not null,
        enkelbestemming varchar(255),
        primary key (id)
    );

    create table configuration (
       id  serial not null,
        key varchar(255),
        value varchar(255),
        primary key (id)
    );

    create table dubbelbestemming (
       id  serial not null,
        bestemmingshoofdgroep varchar(255),
        primary key (id)
    );

    create table enkelbestemming (
       id  serial not null,
        bestemmingshoofdgroep varchar(255),
        primary key (id)
    );

    create table figuur (
       id  serial not null,
        artikelnummer varchar(255),
        enkelbestemming varchar(255),
        geometrie bytea,
        identificatie varchar(255),
        naam varchar(255),
        parent_identificatie varchar(255),
        type_plan_object varchar(255),
        verwijzing varchar(255),
        bestemmingsplan int4,
        primary key (id)
    );

    create table functieaanduiding (
       id  serial not null,
        enkelbestemming varchar(255),
        primary key (id)
    );

    create table gebiedsaanduiding (
       id  serial not null,
        gebiedsaanduidinggroep varchar(255),
        primary key (id)
    );

    create table gebruiker (
       id  serial not null,
        password varchar(255),
        passwordhash varchar(255),
        passwordsalt varchar(255),
        username varchar(255),
        primary key (id)
    );

    create table gebruiker_roles (
       gebruiker int4 not null,
        role int4 not null,
        primary key (gebruiker, role)
    );

    create table harvest_job (
       id  serial not null,
        last_run_time timestamp,
        log text,
        status varchar(255),
        type varchar(255),
        url varchar(255),
        primary key (id)
    );

    create table maatvoering (
       id  serial not null,
        primary key (id)
    );

    create table role (
       id int4 not null,
        role varchar(255),
        primary key (id)
    );

    create table waarde_en_type (
       id  serial not null,
        parent_identificatie varchar(255),
        symbool_code varchar(255),
        waarde varchar(255),
        waarde_type varchar(255),
        maatvoering int4,
        primary key (id)
    );

    alter table besluitsubvlak 
       add constraint FKj6vf2lu3bah2v1fx6p3u1b95 
       foreign key (besluitgebied) 
       references besluitgebied;

    alter table besluitsubvlak_besluitsubvlakken 
       add constraint FKege5chdtj93wbfedn9krnhu32 
       foreign key (besluitsubvlak) 
       references besluitsubvlak;

    alter table besluitsubvlak_besluitvlakken 
       add constraint FKdycl9m1xd7suv221shhys3ccs 
       foreign key (besluitsubvlak) 
       references besluitsubvlak;

    alter table besluitvlak 
       add constraint FKiiudpnduuhw7n7hs9deeheclr 
       foreign key (besluitgebied) 
       references besluitgebied;

    alter table figuur 
       add constraint FKmldhblrnskijdf79w73nbtcvi 
       foreign key (bestemmingsplan) 
       references bestemmingsplan;

    alter table gebruiker_roles 
       add constraint FK4g8m6v397gg9pcu93naoxery7 
       foreign key (role) 
       references role;

    alter table gebruiker_roles 
       add constraint FK5o92cclivkgheiwmt8ud5pjbl 
       foreign key (gebruiker) 
       references gebruiker;

    alter table waarde_en_type 
       add constraint FKq1pn7syya2jvb86vu2h0quiea 
       foreign key (maatvoering) 
       references maatvoering;
