/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.imro.harvester.parser;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.bind.JAXBException;
import nl.b3p.imro.harvester.parser.Geleideformulier;
import nl.b3p.imro.harvester.parser.IMROParser;
import nl.b3p.imro.harvester.parser.IMROParser2006;
import nl.b3p.imro.harvester.parser.IMROParser2008;
import nl.b3p.imro.harvester.parser.IMROParser2012_10;
import nl.b3p.imro.harvester.parser.IMROParser2012_11;
import nl.b3p.imro.harvester.parser.STRIParser;
import nl.b3p.imro.harvester.parser.STRIParser2006;
import nl.b3p.imro.harvester.parser.STRIParser2008;
import nl.b3p.imro.harvester.parser.STRIParser2012;
import nl.b3p.imro.harvester.processing.ROType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;

public class ParserFactory {
    private static final Log log = LogFactory.getLog(ParserFactory.class);
    private IMROParser2006 imro2006 = new IMROParser2006();
    private IMROParser2008 imro2008 = new IMROParser2008();
    private IMROParser2012_10 imro2012V10 = new IMROParser2012_10();
    private IMROParser2012_11 imro2012V11 = new IMROParser2012_11();
    private STRIParser2012 stri2012 = new STRIParser2012();
    private STRIParser2008 stri2008 = new STRIParser2008();
    private STRIParser2006 stri2006 = new STRIParser2006();
    protected static final Element STRI2006_ROOTELEMENT_MANIFEST = new Element("Manifest", Namespace.getNamespace((String)"http://www.geonovum.nl/stri/2006/1"));
    protected static final Element STRI2006_ROOTELEMENT_GELEIDEFORMULIER = new Element("GeleideFormulier", Namespace.getNamespace((String)"http://www.geonovum.nl/stri/2006/1"));
    protected static final Element STRI2008_ROOTELEMENT_MANIFEST = new Element("Manifest", Namespace.getNamespace((String)"http://www.geonovum.nl/stri/2008/1"));
    protected static final Element STRI2008_ROOTELEMENT_GELEIDEFORMULIER = new Element("GeleideFormulier", Namespace.getNamespace((String)"http://www.geonovum.nl/stri/2008/1"));
    protected static final Element STRI2012V1_ROOTELEMENT_MANIFEST = new Element("Manifest", Namespace.getNamespace((String)"http://www.geonovum.nl/stri/2012/1.0"));
    protected static final Element STRI2012V1_ROOTELEMENT_GELEIDEFORMULIER = new Element("GeleideFormulier", Namespace.getNamespace((String)"http://www.geonovum.nl/stri/2012/1.0"));
    protected static final Element STRI2012V2_ROOTELEMENT_MANIFEST = new Element("Manifest", Namespace.getNamespace((String)"http://www.geonovum.nl/stri/2012/2.0"));
    protected static final Element STRI2012V2_ROOTELEMENT_GELEIDEFORMULIER = new Element("GeleideFormulier", Namespace.getNamespace((String)"http://www.geonovum.nl/stri/2012/2.0"));
    protected static final Element IMRO2006_ROOTELEMENT = new Element("FeatureCollection", Namespace.getNamespace((String)"http://www.opengis.net/gml"));
    protected static final Element IMRO2008_ROOTELEMENT = new Element("FeatureCollectionIMRO", Namespace.getNamespace((String)"http://www.geonovum.nl/imro/2008/1"));
    protected static final Element IMRO2012V10_ROOTELEMENT = new Element("FeatureCollectionIMRO", Namespace.getNamespace((String)"http://www.geonovum.nl/imro/2012/1.0"));
    protected static final Element IMRO2012V11_ROOTELEMENT = new Element("FeatureCollectionIMRO", Namespace.getNamespace((String)"http://www.geonovum.nl/imro/2012/1.1"));

    public STRIParser getSTRIParser(URL u) throws IOException, JDOMException, URISyntaxException {
        ROType type = ParserFactory.getROType(u);
        if (type.equals((Object)ROType.STRI2012)) {
            return this.stri2012;
        }
        if (type.equals((Object)ROType.STRI2008)) {
            return this.stri2008;
        }
        if (type.equals((Object)ROType.STRI2006)) {
            return this.stri2006;
        }
        throw new UnsupportedOperationException("Not Yet implemented stri version " + (Object)((Object)type));
    }

    public IMROParser getIMROParser(Geleideformulier geleideformulier) throws IOException, JDOMException, JAXBException, URISyntaxException {
        ROType type = ParserFactory.getROType(geleideformulier.getGML());
        if (type.equals((Object)ROType.IMRO2006)) {
            return this.imro2006;
        }
        if (type.equals((Object)ROType.IMRO2008)) {
            return this.imro2008;
        }
        if (type.equals((Object)ROType.IMRO2012V10)) {
            return this.imro2012V10;
        }
        if (type.equals((Object)ROType.IMRO2012V11)) {
            return this.imro2012V11;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static ROType getROType(URL inputXmlFullPath) throws IOException, JDOMException, URISyntaxException {
        Document inputXml;
        block11: {
            inputXml = null;
            if (!inputXmlFullPath.toExternalForm().startsWith("file:")) {
                HttpGet httpGet;
                CloseableHttpClient client = HttpClientBuilder.create().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build();
                HttpResponse response = client.execute((HttpUriRequest)(httpGet = new HttpGet(inputXmlFullPath.toURI())));
                int statuscode = response.getStatusLine().getStatusCode();
                if (statuscode >= 200 && statuscode <= 299) {
                    HttpEntity entity = response.getEntity();
                    inputXml = new SAXBuilder().build(entity.getContent());
                    break block11;
                } else {
                    String statusLine = response.getStatusLine().getReasonPhrase();
                    throw new IOException(statuscode + ": " + statusLine);
                }
            }
            inputXml = new SAXBuilder().build(inputXmlFullPath);
        }
        if (!inputXml.hasRootElement()) {
            throw new IllegalArgumentException("Document contains no root element");
        }
        Element rootElem = inputXml.getRootElement();
        if (ParserFactory.isElementEqual(rootElem, IMRO2006_ROOTELEMENT)) {
            return ROType.IMRO2006;
        }
        if (ParserFactory.isElementEqual(rootElem, IMRO2008_ROOTELEMENT)) {
            return ROType.IMRO2008;
        }
        if (ParserFactory.isElementEqual(rootElem, IMRO2012V10_ROOTELEMENT)) {
            return ROType.IMRO2012V10;
        }
        if (ParserFactory.isElementEqual(rootElem, IMRO2012V11_ROOTELEMENT)) {
            return ROType.IMRO2012V11;
        }
        if (ParserFactory.isElementEqual(rootElem, STRI2012V1_ROOTELEMENT_GELEIDEFORMULIER) || ParserFactory.isElementEqual(rootElem, STRI2012V1_ROOTELEMENT_MANIFEST) || ParserFactory.isElementEqual(rootElem, STRI2012V2_ROOTELEMENT_GELEIDEFORMULIER) || ParserFactory.isElementEqual(rootElem, STRI2012V2_ROOTELEMENT_MANIFEST)) {
            return ROType.STRI2012;
        }
        if (ParserFactory.isElementEqual(rootElem, STRI2008_ROOTELEMENT_GELEIDEFORMULIER) || ParserFactory.isElementEqual(rootElem, STRI2008_ROOTELEMENT_MANIFEST)) {
            return ROType.STRI2008;
        }
        if (!ParserFactory.isElementEqual(rootElem, STRI2006_ROOTELEMENT_GELEIDEFORMULIER) && !ParserFactory.isElementEqual(rootElem, STRI2006_ROOTELEMENT_MANIFEST)) {
            log.error((Object)("Unrecognized root element: " + rootElem));
            return ROType.UNKNOWN;
        }
        return ROType.STRI2006;
    }

    private static boolean isElementEqual(Element elem1, Element elem2) {
        return elem1.getName().equals(elem2.getName()) && elem1.getNamespaceURI().equals(elem2.getNamespaceURI());
    }
}

