/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.imro.harvester.parser;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import nl.b3p.imro.harvester.parser.Geleideformulier;
import nl.b3p.imro.harvester.parser.STRIParser;
import nl.b3p.imro.harvester.processing.HarvesterInitializer;
import nl.b3p.imro.harvester.processing.StatusReport;
import nl.b3p.stri._2008._1.GeleideFormulier;
import nl.b3p.stri._2008._1.Manifest;
import nl.b3p.stri._2008._1.Plan;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class STRIParser2008
implements STRIParser {
    private static final Log log = LogFactory.getLog(STRIParser2008.class);
    private final JAXBContext jaxbSTRIContext = JAXBContext.newInstance((String)"nl.b3p.stri._2008._1");

    public List<URL> getGeleideformulierURLSFromManifest(URL manifestURL) throws JAXBException, MalformedURLException {
        ArrayList<URL> geleideformulieren = new ArrayList<URL>();
        try {
            Unmarshaller jaxbUnmarshaller = this.jaxbSTRIContext.createUnmarshaller();
            Manifest manifest = (Manifest)this.retrieveXMLObjectFromURL(manifestURL, jaxbUnmarshaller);
            List plannen = manifest.getPlan();
            for (Plan plan : plannen) {
                geleideformulieren.add(new URL(plan.getOnderdelen().getBasisURL() + plan.getOnderdelen().getGeleideFormulier()));
            }
        }
        catch (IOException | URISyntaxException ex) {
            log.error((Object)("Cannot retrieve geleideformulieren from manifest: " + manifestURL.toExternalForm()));
        }
        return geleideformulieren;
    }

    public List<Geleideformulier> retrieveGeleideformulieren(List<URL> geleideformulieren, StatusReport report) throws MalformedURLException, JAXBException {
        ArrayList<Geleideformulier> formulieren = new ArrayList<Geleideformulier>();
        Unmarshaller jaxbUnmarshaller = this.jaxbSTRIContext.createUnmarshaller();
        for (URL formulierURL : geleideformulieren) {
            try {
                GeleideFormulier striGeleideform = (GeleideFormulier)this.retrieveXMLObjectFromURL(formulierURL, jaxbUnmarshaller);
                Plan plan = striGeleideform.getPlan();
                Plan.Eigenschappen eigenschappen = plan.getEigenschappen();
                if (eigenschappen.getType() != null && HarvesterInitializer.canProcessPlantype((String)eigenschappen.getType().value())) {
                    Geleideformulier geleideformulier = new Geleideformulier();
                    Plan.Onderdelen onderdelen = plan.getOnderdelen();
                    Plan.Supplementen supplementen = plan.getSupplementen();
                    String identificatie = plan.getId();
                    String basisURL = onderdelen.getBasisURL();
                    geleideformulier.setIdentificatie(identificatie);
                    geleideformulier.setNaam(eigenschappen.getNaam());
                    geleideformulier.setType(eigenschappen.getType().value());
                    geleideformulier.setStatus(eigenschappen.getStatus().value());
                    geleideformulier.setDatum(eigenschappen.getDatum().toString());
                    geleideformulier.setVersie(eigenschappen.getVersieIMRO());
                    geleideformulier.setBasisURL(basisURL);
                    geleideformulier.setImro(onderdelen.getIMRO());
                    for (String regel : onderdelen.getRegels()) {
                        geleideformulier.getBijlages().add(new URL(basisURL + regel));
                    }
                    for (String regelsBijlage : onderdelen.getRegelsBijlage()) {
                        geleideformulier.getBijlages().add(new URL(basisURL + regelsBijlage));
                    }
                    for (String toelichting : onderdelen.getToelichting()) {
                        geleideformulier.getBijlages().add(new URL(basisURL + toelichting));
                    }
                    for (String toelichtingBijlage : onderdelen.getToelichtingBijlage()) {
                        geleideformulier.getBijlages().add(new URL(basisURL + toelichtingBijlage));
                    }
                    if (onderdelen.getGeleideFormulier() != null) {
                        geleideformulier.getBijlages().add(new URL(basisURL + onderdelen.getGeleideFormulier()));
                    }
                    if (onderdelen.getVaststellingsBesluit() != null) {
                        geleideformulier.getBijlages().add(new URL(basisURL + onderdelen.getVaststellingsBesluit()));
                    }
                    if (onderdelen.getPlanTeksten() != null) {
                        geleideformulier.getBijlages().add(new URL(basisURL + onderdelen.getPlanTeksten()));
                    }
                    for (String beleidsDocument : onderdelen.getBeleidsDocument()) {
                        geleideformulier.getBijlages().add(new URL(basisURL + beleidsDocument));
                    }
                    for (String beleidsDocumentBijlage : onderdelen.getBeleidsDocumentBijlage()) {
                        geleideformulier.getBijlages().add(new URL(basisURL + beleidsDocumentBijlage));
                    }
                    if (onderdelen.getBesluitDocument() != null) {
                        geleideformulier.getBijlages().add(new URL(basisURL + onderdelen.getBesluitDocument()));
                    }
                    for (String besldocbijl : onderdelen.getBesluitDocumentBijlage()) {
                        geleideformulier.getBijlages().add(new URL(basisURL + besldocbijl));
                    }
                    for (String beleidsTekst : onderdelen.getBeleidsTekst()) {
                        geleideformulier.getBijlages().add(new URL(basisURL + beleidsTekst));
                    }
                    for (String beleidsTekstBijlage : onderdelen.getBeleidsTekstBijlage()) {
                        geleideformulier.getBijlages().add(new URL(basisURL + beleidsTekstBijlage));
                    }
                    for (String illustratie : onderdelen.getIllustratie()) {
                        geleideformulier.getBijlages().add(new URL(basisURL + illustratie));
                    }
                    geleideformulier.getBijlages().add(new URL(basisURL + onderdelen.getIMRO()));
                    formulieren.add(geleideformulier);
                    continue;
                }
                String message = "Type niet ondersteund: " + eigenschappen.getType();
                if (eigenschappen.getType() != null) {
                    message = message + " - " + eigenschappen.getType().value();
                    report.addSkipped(message);
                    throw new IllegalArgumentException(message);
                }
                IllegalArgumentException e = new IllegalArgumentException(message);
                report.addErrored(plan.getId(), (Exception)e);
                throw e;
            }
            catch (IOException | URISyntaxException ex) {
                log.error((Object)"Cannot retrieve manifest: ", (Throwable)ex);
                report.addSkipped("Cannot retrieve manifest: " + formulierURL.toExternalForm());
            }
        }
        return formulieren;
    }
}

