/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.imro.harvester.processing;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import nl.b3p.imro.harvester.entities.Configuration;
import nl.b3p.imro.harvester.processing.JobExecutor;
import nl.geonovum.stri._2012._1.TypePlan;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;
import org.stripesstuff.stripersist.Stripersist;

/*
 * Exception performing whole class analysis ignored.
 */
public class HarvesterInitializer
implements Servlet {
    protected static final Log log = LogFactory.getLog(HarvesterInitializer.class);
    public static final String JOB_NAME = "harvestJobsExecutor";
    public static final String TRIGGER_NAME = "harvestJobsTrigger";
    public static final String GROUP_NAME = "harvestGroup";
    private ServletConfig config;
    private static Scheduler scheduler;
    private static File downloadFolder;
    public static final List<String> SUPPORTED_PLAN_TYPES;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ServletConfig sc) throws ServletException {
        this.config = sc;
        log.debug((Object)"Initializing quartz.");
        try {
            String cronschedule = "0 0 3 1/1 * ? *";
            Stripersist.requestInit();
            EntityManager em = Stripersist.getEntityManager((String)"imroPU");
            try {
                Configuration cron = (Configuration)em.createQuery("FROM Configuration where key = :cronKey", Configuration.class).setParameter("cronKey", (Object)"cronexpression").getSingleResult();
                cronschedule = cron.getValue();
            }
            catch (NoResultException cron) {
                // empty catch block
            }
            JobDetail job = JobBuilder.newJob(JobExecutor.class).withIdentity("harvestJobsExecutor", "harvestGroup").build();
            Trigger trigger = TriggerBuilder.newTrigger().withIdentity("harvestJobsTrigger", "harvestGroup").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronschedule)).build();
            scheduler = new StdSchedulerFactory().getScheduler();
            scheduler.start();
            scheduler.scheduleJob(job, trigger);
            SimpleDateFormat sdf = new SimpleDateFormat("kk:mm dd-MM-yyyy");
            log.debug((Object)("Quartz initialized. Next run is: " + sdf.format(trigger.getNextFireTime())));
        }
        catch (SchedulerException ex) {
            log.error((Object)"Cannot create scheduler", (Throwable)ex);
        }
        catch (Exception e) {
            log.error((Object)"Error creating scheduler", (Throwable)e);
        }
        finally {
            Stripersist.requestComplete();
        }
        try {
            Stripersist.requestInit();
            EntityManager em = Stripersist.getEntityManager((String)"imroPU");
            try {
                Configuration downloadFolderConfig = (Configuration)em.createQuery("FROM Configuration where key = :cronKey", Configuration.class).setParameter("cronKey", (Object)"download.folder").getSingleResult();
                downloadFolder = new File(downloadFolderConfig.getValue());
            }
            catch (NoResultException noResultException) {}
        }
        catch (Exception e) {
            log.error((Object)"Cannot load downloadfolder configuration: ", (Throwable)e);
        }
        HarvesterInitializer.initPlantypes();
    }

    public static void initPlantypes() {
        SUPPORTED_PLAN_TYPES.add(nl.b3p.stri._2006._12b.TypePlan.GEMEENTELIJK_PLAN_BESTEMMINGSPLAN_ARTIKEL_10.value());
        SUPPORTED_PLAN_TYPES.add(nl.b3p.stri._2006._12b.TypePlan.GEMEENTELIJK_PLAN_WIJZIGINGSPLAN_ARTIKEL_11.value());
        SUPPORTED_PLAN_TYPES.add(nl.b3p.stri._2008._1.TypePlan.BESTEMMINGSPLAN.value());
        SUPPORTED_PLAN_TYPES.add(nl.b3p.stri._2008._1.TypePlan.PROJECTBESLUIT.value());
        SUPPORTED_PLAN_TYPES.add(nl.b3p.stri._2008._1.TypePlan.WIJZIGINGSPLAN.value());
        SUPPORTED_PLAN_TYPES.add(nl.b3p.stri._2008._1.TypePlan.BEHEERSVERORDENING.value());
        SUPPORTED_PLAN_TYPES.add(TypePlan.OMGEVINGSVERGUNNING.value());
        SUPPORTED_PLAN_TYPES.add(TypePlan.UITWERKINGSPLAN.value());
        SUPPORTED_PLAN_TYPES.add(TypePlan.BEHEERSVERORDENING.value());
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public void service(ServletRequest sr, ServletResponse sr1) throws ServletException, IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getServletInfo() {
        return "Init quartz";
    }

    public void destroy() {
        if (scheduler != null) {
            try {
                scheduler.shutdown();
            }
            catch (SchedulerException ex) {
                log.error((Object)"Cannot shutdown quartz scheduler: ", (Throwable)ex);
            }
        }
    }

    public static void setDownloadFolder(File downloadFolder) {
        HarvesterInitializer.downloadFolder = downloadFolder;
    }

    public static File getDownloadFolder() {
        return downloadFolder;
    }

    public static Scheduler getScheduler() {
        return scheduler;
    }

    public static Trigger getTrigger() throws SchedulerException {
        return scheduler.getTrigger(new TriggerKey("harvestJobsTrigger", "harvestGroup"));
    }

    public static void updateTrigger(String cronexpression) throws SchedulerException {
        Trigger oldTrigger = HarvesterInitializer.getTrigger();
        TriggerBuilder tb = oldTrigger.getTriggerBuilder();
        Trigger newTrigger = tb.withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronexpression)).build();
        scheduler.rescheduleJob(oldTrigger.getKey(), newTrigger);
    }

    public static String getNextExecutionTime() throws SchedulerException {
        Trigger t = HarvesterInitializer.getTrigger();
        SimpleDateFormat sdf = new SimpleDateFormat("kk:mm dd-MM-yyyy");
        Date d = t.getNextFireTime();
        return sdf.format(d);
    }

    public static boolean canProcessPlantype(String type) {
        return SUPPORTED_PLAN_TYPES.contains(type);
    }

    static {
        downloadFolder = null;
        SUPPORTED_PLAN_TYPES = new ArrayList();
    }
}

