/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.imro.harvester.entities;

import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Type;

@Entity
public class HarvestJob {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private int id;
    private String url;
    @Enumerated(value=EnumType.STRING)
    private HarvestJobType type;
    @Enumerated(value=EnumType.STRING)
    private HarvestJobStatus status;
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    private String log;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastRunTime;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public HarvestJobType getType() {
        return this.type;
    }

    public void setType(HarvestJobType type) {
        this.type = type;
    }

    public HarvestJobStatus getStatus() {
        return this.status;
    }

    public void setStatus(HarvestJobStatus status) {
        this.status = status;
    }

    public String getLog() {
        return this.log;
    }

    public void setLog(String log) {
        this.log = log;
    }

    public Date getLastRunTime() {
        return this.lastRunTime;
    }

    public void setLastRunTime(Date lastRunTime) {
        this.lastRunTime = lastRunTime;
    }

    public static enum HarvestJobStatus {
        FATAAL("Fataal"),
        GOED("Goed"),
        BEZIG("Bezig"),
        MEDIUMPROBLEEM("Medium probleem");

        private final String value;

        private HarvestJobStatus(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public String getValue() {
            return this.value;
        }

        public static HarvestJobStatus fromValue(String v) {
            for (HarvestJobStatus c : HarvestJobStatus.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }

    public static enum HarvestJobType {
        RUIMTELIJKEPLANNENSCRAPER("Ruimtelijke plannen"),
        DIRECT("Directe URL");

        private final String value;

        private HarvestJobType(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public String getValue() {
            return this.value;
        }

        public static HarvestJobType fromValue(String v) {
            for (HarvestJobType c : HarvestJobType.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

