/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.loader.jdbc;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.Calendar;
import javax.xml.bind.DatatypeConverter;
import nl.b3p.brmo.loader.jdbc.ColumnMetadata;

public abstract class GeometryJdbcConverter {
    protected final WKTReader wkt = new WKTReader();

    public abstract Object convertToNativeGeometryObject(Geometry var1) throws SQLException, ParseException;

    public abstract Geometry convertToJTSGeometryObject(Object var1);

    public abstract String createPSGeometryPlaceholder() throws SQLException;

    public abstract String getSchema();

    public abstract String getGeomTypeName();

    public abstract boolean isDuplicateKeyViolationMessage(String var1);

    public abstract String buildPaginationSql(String var1, int var2, int var3);

    public abstract StringBuilder buildLimitSql(StringBuilder var1, int var2);

    public abstract boolean useSavepoints();

    public abstract boolean isPmdKnownBroken();

    public abstract String getMViewsSQL();

    public abstract String getMViewRefreshSQL(String var1);

    public abstract String getGeotoolsDBTypeName();

    public Object convertToNativeGeometryObject(String param) throws ParseException, SQLException {
        Geometry o = null;
        if (param != null) {
            o = this.wkt.read(param);
        }
        return this.convertToNativeGeometryObject(o);
    }

    public static Object convertToSQLObject(String stringValue, ColumnMetadata cm, String tableName, String column) {
        Object param = null;
        stringValue = stringValue.trim();
        switch (cm.getDataType()) {
            case 2: 
            case 3: 
            case 4: {
                try {
                    param = new BigDecimal(stringValue);
                    break;
                }
                catch (NumberFormatException nfe) {
                    throw new NumberFormatException(String.format("Conversie van waarde \"%s\" naar type %s voor %s.%s niet mogelijk", stringValue, cm.getTypeName(), tableName, cm.getName()));
                }
            }
            case 1: 
            case 12: {
                param = stringValue;
                break;
            }
            case 91: 
            case 93: {
                param = DatatypeConverter.parseDateTime((String)stringValue);
                if (param == null) break;
                Calendar cal = (Calendar)param;
                param = new Date(cal.getTimeInMillis());
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Data type %s (#%d) van kolom \"%s\" wordt niet ondersteund.", cm.getTypeName(), cm.getDataType(), column));
            }
        }
        return param;
    }
}

