/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.loader.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.sourceforge.jtds.jdbc.JtdsConnection;
import nl.b3p.brmo.loader.jdbc.GeometryJdbcConverter;
import nl.b3p.brmo.loader.jdbc.HSQLJdbcConverter;
import nl.b3p.brmo.loader.jdbc.MssqlConnectionUnwrapper;
import nl.b3p.brmo.loader.jdbc.MssqlJdbcConverter;
import nl.b3p.brmo.loader.jdbc.Oracle11JdbcConverter;
import nl.b3p.brmo.loader.jdbc.OracleConnectionUnwrapper;
import nl.b3p.brmo.loader.jdbc.OracleJdbcConverter;
import nl.b3p.brmo.loader.jdbc.PostgisJdbcConverter;
import oracle.jdbc.OracleConnection;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GeometryJdbcConverterFactory {
    private static final Log LOG = LogFactory.getLog(GeometryJdbcConverterFactory.class);

    public static GeometryJdbcConverter getGeometryJdbcConverter(Connection conn) {
        String databaseProductName = null;
        try {
            databaseProductName = conn.getMetaData().getDatabaseProductName();
        }
        catch (SQLException ex) {
            throw new UnsupportedOperationException("Cannot get database product name", ex);
        }
        if (databaseProductName.contains("PostgreSQL")) {
            PostgisJdbcConverter geomToJdbc = new PostgisJdbcConverter();
            try {
                String schema = (String)new QueryRunner().query(conn, "select current_schema", (ResultSetHandler)new ScalarHandler());
                geomToJdbc.setSchema(schema);
            }
            catch (SQLException ex) {
                throw new UnsupportedOperationException("Cannot get/set schema: " + databaseProductName, ex);
            }
            return geomToJdbc;
        }
        if (databaseProductName.contains("Oracle")) {
            boolean oracle11 = false;
            try {
                oracle11 = conn.getMetaData().getDatabaseMajorVersion() == 11;
            }
            catch (SQLException ex) {
                LOG.warn((Object)"Uitlezen database versie is mislukt.", (Throwable)ex);
            }
            try {
                OracleConnection oc = OracleConnectionUnwrapper.unwrap(conn);
                OracleJdbcConverter geomToJdbc = oracle11 ? new Oracle11JdbcConverter(oc) : new OracleJdbcConverter(oc);
                geomToJdbc.setSchema(oc.getCurrentSchema());
                return geomToJdbc;
            }
            catch (SQLException ex) {
                throw new UnsupportedOperationException("Cannot get connection: " + databaseProductName, ex);
            }
        }
        if (databaseProductName.contains("Microsoft SQL Server")) {
            MssqlJdbcConverter geomToJdbc = new MssqlJdbcConverter();
            try {
                String schema;
                JtdsConnection c = MssqlConnectionUnwrapper.unwrap(conn);
                try (Statement s = c.createStatement(1005, 1007);){
                    ResultSet rs = s.executeQuery("SELECT SCHEMA_NAME();");
                    rs.last();
                    int numberOfRows = rs.getRow();
                    rs.first();
                    schema = rs.getString(1);
                    rs.close();
                }
                if (schema != null && !schema.isEmpty()) {
                    geomToJdbc.setSchema(schema);
                }
            }
            catch (AbstractMethodError | SQLException ex) {
                throw new UnsupportedOperationException("Cannot get/set schema: " + databaseProductName, ex);
            }
            return geomToJdbc;
        }
        if (databaseProductName.contains("HSQL Database Engine")) {
            return new HSQLJdbcConverter();
        }
        throw new UnsupportedOperationException("Unknown database: " + databaseProductName);
    }
}

