/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.loader.jdbc;

import com.vividsolutions.jts.io.ParseException;
import java.sql.SQLException;
import nl.b3p.brmo.loader.jdbc.GeometryJdbcConverter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.codec.Wkt;
import org.geolatte.geom.codec.db.sqlserver.Encoders;

public class MssqlJdbcConverter
extends GeometryJdbcConverter {
    private static final Log log = LogFactory.getLog(MssqlJdbcConverter.class);
    private String schema = "dbo";

    @Override
    public boolean isDuplicateKeyViolationMessage(String message) {
        return message != null && message.contains("Cannot insert duplicate key in object");
    }

    @Override
    public String createPSGeometryPlaceholder() throws SQLException {
        return "?";
    }

    @Override
    public Object convertToNativeGeometryObject(com.vividsolutions.jts.geom.Geometry g, int srid) throws SQLException, ParseException {
        if (g == null) {
            return null;
        }
        String param = g.toText();
        if (param == null || param.trim().length() == 0) {
            return null;
        }
        Geometry geom = Wkt.fromWkt((String)("SRID=" + srid + "; " + param));
        byte[] ret = Encoders.encode((Geometry)geom);
        return ret;
    }

    @Override
    public Object convertToNativeGeometryObject(com.vividsolutions.jts.geom.Geometry g) throws SQLException, ParseException {
        return this.convertToNativeGeometryObject(g, 28992);
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    @Override
    public String getGeomTypeName() {
        return "geometry";
    }

    @Override
    public String buildPaginationSql(String sql, int offset, int limit) {
        StringBuilder builder = new StringBuilder(sql);
        if (!StringUtils.containsIgnoreCase((CharSequence)sql, (CharSequence)"ORDER BY")) {
            builder.append(" ORDER BY id ");
        }
        builder.append(" OFFSET ");
        builder.append(offset);
        builder.append(" ROWS FETCH NEXT ");
        builder.append(limit);
        builder.append(" ROWS ONLY ");
        return builder.toString();
    }

    @Override
    public StringBuilder buildLimitSql(StringBuilder sql, int limit) {
        String s = this.buildPaginationSql(sql.toString(), 0, limit);
        return new StringBuilder(s);
    }

    @Override
    public boolean useSavepoints() {
        return false;
    }

    @Override
    public boolean isPmdKnownBroken() {
        return false;
    }

    @Override
    public String getGeotoolsDBTypeName() {
        String name = "jtds-sqlserver";
        return "jtds-sqlserver";
    }

    @Override
    public String getMViewsSQL() {
        return "select 1 from brmo_metadata where 1 = 2";
    }

    @Override
    public String getMViewRefreshSQL(String mview) {
        return this.getMViewsSQL();
    }

    @Override
    public com.vividsolutions.jts.geom.Geometry convertToJTSGeometryObject(Object nativeObj) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

