/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.loader.jdbc;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import nl.b3p.loader.jdbc.GeometryJdbcConverter;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HSQLJdbcConverter
extends GeometryJdbcConverter {
    protected static final Log log = LogFactory.getLog(HSQLJdbcConverter.class);

    @Override
    public Object convertToNativeGeometryObject(Geometry param) throws SQLException, ParseException {
        return this.convertToNativeGeometryObject(param, 28992);
    }

    @Override
    public String createPSGeometryPlaceholder() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getGeomTypeName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Geometry convertToJTSGeometryObject(Object nativeObj) {
        try {
            Clob c = (Clob)nativeObj;
            if (c == null) {
                return null;
            }
            InputStream in = c.getAsciiStream();
            StringWriter w = new StringWriter();
            IOUtils.copy((InputStream)in, (Writer)w);
            Geometry g = this.wkt.read(w.toString());
            return g;
        }
        catch (ParseException | IOException | SQLException ex) {
            log.error((Object)"Error parsing clob to geometry", ex);
            return null;
        }
    }

    @Override
    public boolean isPmdKnownBroken() {
        return false;
    }

    @Override
    public String getSchema() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isDuplicateKeyViolationMessage(String message) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String buildPaginationSql(String sql, int offset, int limit) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public StringBuilder buildLimitSql(StringBuilder sql, int limit) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean useSavepoints() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getMViewsSQL() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getMViewRefreshSQL(String mview) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getGeotoolsDBTypeName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object convertToNativeGeometryObject(Geometry param, int srid) throws SQLException, ParseException {
        if (param == null) {
            return null;
        }
        return param.toText();
    }
}

