/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.loader.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import net.sourceforge.jtds.jdbc.JtdsConnection;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.PoolableConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MssqlConnectionUnwrapper {
    private static final Log LOG = LogFactory.getLog(MssqlConnectionUnwrapper.class);

    public static JtdsConnection unwrap(Connection c) throws SQLException {
        LOG.trace((Object)("Unwrapping jTDS connection, connection class: " + c.getClass().getName()));
        Connection mdC = c.getMetaData().getConnection();
        LOG.trace((Object)("MetaData connection class: " + mdC.getClass().getName()));
        JtdsConnection oc = null;
        try {
            if (mdC.isWrapperFor(JtdsConnection.class)) {
                oc = mdC.unwrap(JtdsConnection.class);
            }
        }
        catch (AbstractMethodError e) {
            LOG.trace((Object)"Connection ondersteund geen 'isWrapperFor' of 'unwrap' - dit is verwacht voor een DelegatingConnection|PoolableConnection.");
        }
        if (oc == null) {
            if (mdC instanceof JtdsConnection) {
                oc = (JtdsConnection)mdC;
            } else if (mdC instanceof PoolableConnection) {
                oc = (JtdsConnection)((DelegatingConnection)mdC).getDelegate();
            } else {
                throw new SQLException("Kan connectie niet unwrappen naar JtdsConnection!");
            }
        }
        return oc;
    }
}

