/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.jdbc.util.converter;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.OracleConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.dbcp.dbcp2.DelegatingConnection;
import org.apache.tomcat.dbcp.dbcp2.PoolableConnection;

public class OracleConnectionUnwrapper {
    private static final Log LOG = LogFactory.getLog(OracleConnectionUnwrapper.class);

    public static OracleConnection unwrap(Connection c) throws SQLException {
        LOG.trace((Object)("Unwrapping Oracle connection, isWrapperFor(OracleConnection.class): " + c.isWrapperFor(OracleConnection.class)));
        LOG.trace((Object)("Connection class: " + c.getClass().getName()));
        Connection mdC = c.getMetaData().getConnection();
        LOG.trace((Object)("MetaData connection class: " + mdC.getClass().getName()));
        if (c.isWrapperFor(OracleConnection.class)) {
            LOG.trace((Object)"Unwrap Connection voor OracleConnection");
            return c.unwrap(OracleConnection.class);
        }
        if (mdC instanceof OracleConnection) {
            LOG.trace((Object)"Cast MetaData Connection naar OracleConnection");
            return (OracleConnection)mdC;
        }
        if (mdC instanceof PoolableConnection) {
            LOG.trace((Object)"Cast naar OracleConnection via cast naar tomcat DelegatingConnection");
            return (OracleConnection)((DelegatingConnection)mdC).getDelegate();
        }
        if (DelegatingConnection.class.isAssignableFrom(c.getClass())) {
            LOG.trace((Object)"Cast InnermostDelegate van DelegatingConnection connection");
            return (OracleConnection)((DelegatingConnection)c).getInnermostDelegate();
        }
        throw new SQLException("Kan connectie niet unwrappen naar OracleConnection van meta connectie: " + mdC.getClass().getName() + ", connection: " + c.getClass().getName());
    }
}

