/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.jdbc.util.converter;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;

public class ColumnMetadata
implements Comparable<ColumnMetadata> {
    private final String defaultValue;
    private String name;
    private int position;
    private int dataType;
    private String typeName;
    private int size;
    private Integer decimalDigits;
    private boolean nullable;
    private Integer charOctetLength;
    private boolean autoIncrement;

    public ColumnMetadata(ResultSet columnMetadataRs) throws SQLException {
        this.name = columnMetadataRs.getString("COLUMN_NAME");
        this.dataType = columnMetadataRs.getInt("DATA_TYPE");
        this.typeName = columnMetadataRs.getString("TYPE_NAME");
        this.size = columnMetadataRs.getInt("COLUMN_SIZE");
        Object o = columnMetadataRs.getObject("DECIMAL_DIGITS");
        if (o != null) {
            if (o instanceof BigDecimal) {
                this.decimalDigits = ((BigDecimal)o).intValue();
            } else if (o instanceof Integer) {
                this.decimalDigits = (Integer)o;
            }
        }
        this.nullable = 1 == columnMetadataRs.getInt("NULLABLE");
        this.defaultValue = columnMetadataRs.getString("COLUMN_DEF");
        o = columnMetadataRs.getObject("CHAR_OCTET_LENGTH");
        if (o != null) {
            if (o instanceof BigDecimal) {
                this.charOctetLength = ((BigDecimal)o).intValue();
            } else if (o instanceof Integer) {
                this.charOctetLength = (Integer)o;
            }
        }
        this.position = columnMetadataRs.getInt("ORDINAL_POSITION");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setDataType(int dataType) {
        this.dataType = dataType;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public Integer getDecimalDigits() {
        return this.decimalDigits;
    }

    public void setDecimalDigits(Integer decimalDigits) {
        this.decimalDigits = decimalDigits;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public Integer getCharOctetLength() {
        return this.charOctetLength;
    }

    public void setCharOctetLength(Integer charOctetLength) {
        this.charOctetLength = charOctetLength;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public void setAutoIncrement(boolean autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    public String toString() {
        return this.toString("%s %4d %s %s bytes=%d %s %s");
    }

    public String typeToString() {
        return this.typeName + "(" + this.size + (String)(this.decimalDigits == null ? "" : "," + this.decimalDigits) + ")";
    }

    public String toStringFixedWidth(Collection<ColumnMetadata> allColumns) {
        int nameWidth = this.name.length();
        int typeWidth = this.typeToString().length();
        for (ColumnMetadata c : allColumns) {
            nameWidth = Math.max(c.getName().length(), nameWidth);
            typeWidth = Math.max(c.typeToString().length(), typeWidth);
        }
        return this.toString("%-" + nameWidth + "s %4d %-" + typeWidth + "s %8s bytes=%d %s %s");
    }

    private String toString(String formatString) {
        return String.format(formatString, this.name, this.dataType, this.typeToString(), this.nullable ? "NULL" : "NOT NULL", this.charOctetLength, this.autoIncrement ? "AUTO INCREMENT" : "", this.defaultValue == null ? "" : "DEFAULT '" + this.defaultValue + "'");
    }

    @Override
    public int compareTo(ColumnMetadata rhs) {
        return Integer.compare(this.position, rhs.position);
    }
}

