/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.loader.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import net.sourceforge.jtds.jdbc.JtdsConnection;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.PoolableConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MssqlConnectionUnwrapper {
    private static final Log LOG = LogFactory.getLog(MssqlConnectionUnwrapper.class);

    public static JtdsConnection unwrap(Connection c) throws SQLException {
        LOG.trace((Object)("Unwrapping jTDS connection, connection class: " + c.getClass().getName()));
        Connection metadataConnection = c.getMetaData().getConnection();
        LOG.trace((Object)("MetaData connection class: " + metadataConnection.getClass().getName()));
        JtdsConnection oc = null;
        try {
            if (metadataConnection.isWrapperFor(JtdsConnection.class)) {
                oc = metadataConnection.unwrap(JtdsConnection.class);
            }
        }
        catch (AbstractMethodError e) {
            LOG.trace((Object)"Connection ondersteund geen 'isWrapperFor' of 'unwrap' - dit is verwacht voor een DelegatingConnection|PoolableConnection.");
        }
        if (oc == null) {
            if (metadataConnection instanceof JtdsConnection) {
                LOG.trace((Object)"Cast naar JtdsConnection");
                oc = (JtdsConnection)metadataConnection;
            } else if (metadataConnection instanceof PoolableConnection) {
                LOG.trace((Object)"Cast naar JtdsConnection via cast naar dbcp DelegatingConnection");
                oc = (JtdsConnection)((DelegatingConnection)metadataConnection).getDelegate();
            } else if (metadataConnection instanceof org.apache.tomcat.dbcp.dbcp.PoolableConnection) {
                LOG.trace((Object)"Cast naar JtdsConnection via cast naar tomcat DelegatingConnection");
                oc = (JtdsConnection)((org.apache.tomcat.dbcp.dbcp.DelegatingConnection)metadataConnection).getDelegate();
            } else {
                throw new SQLException("Kan connectie niet unwrappen naar JtdsConnection van meta connectie: " + metadataConnection.getClass().getName() + ", connection: " + c.getClass().getName());
            }
        }
        return oc;
    }
}

