/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.loader.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import nl.b3p.loader.jdbc.GeometryJdbcConverter;
import nl.b3p.loader.jdbc.HSQLJdbcConverter;
import nl.b3p.loader.jdbc.MssqlJdbcConverter;
import nl.b3p.loader.jdbc.Oracle11JdbcConverter;
import nl.b3p.loader.jdbc.Oracle12JdbcConverter;
import nl.b3p.loader.jdbc.OracleConnectionUnwrapper;
import nl.b3p.loader.jdbc.OracleJdbcConverter;
import nl.b3p.loader.jdbc.PostgisJdbcConverter;
import oracle.jdbc.OracleConnection;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GeometryJdbcConverterFactory {
    private static final Log LOG = LogFactory.getLog(GeometryJdbcConverterFactory.class);

    public static GeometryJdbcConverter getGeometryJdbcConverter(Connection conn) {
        String databaseProductName = null;
        try {
            databaseProductName = conn.getMetaData().getDatabaseProductName();
        }
        catch (SQLException ex) {
            throw new UnsupportedOperationException("Cannot get database product name", ex);
        }
        if (databaseProductName.contains("PostgreSQL")) {
            PostgisJdbcConverter geomToJdbc = new PostgisJdbcConverter();
            try {
                String schema = (String)new QueryRunner().query(conn, "select current_schema", (ResultSetHandler)new ScalarHandler());
                geomToJdbc.setSchema(schema);
            }
            catch (SQLException ex) {
                throw new UnsupportedOperationException("Cannot get/set schema: " + databaseProductName, ex);
            }
            return geomToJdbc;
        }
        if (databaseProductName.contains("Oracle")) {
            int majorVersion = 10;
            try {
                majorVersion = conn.getMetaData().getDatabaseMajorVersion();
            }
            catch (SQLException ex) {
                LOG.warn((Object)"Uitlezen database versie is mislukt.", (Throwable)ex);
            }
            try {
                OracleJdbcConverter geomToJdbc;
                OracleConnection oc = OracleConnectionUnwrapper.unwrap(conn);
                switch (majorVersion) {
                    case 11: {
                        geomToJdbc = new Oracle11JdbcConverter(oc);
                        break;
                    }
                    case 12: {
                        geomToJdbc = new Oracle12JdbcConverter(oc);
                        break;
                    }
                    case 18: 
                    case 19: 
                    case 21: {
                        geomToJdbc = new OracleJdbcConverter(oc);
                        break;
                    }
                    default: {
                        geomToJdbc = new OracleJdbcConverter(oc);
                    }
                }
                geomToJdbc.setSchema(oc.getCurrentSchema());
                return geomToJdbc;
            }
            catch (SQLException ex) {
                throw new UnsupportedOperationException("Cannot get connection: " + databaseProductName, ex);
            }
        }
        if (databaseProductName.contains("Microsoft SQL Server")) {
            MssqlJdbcConverter geomToJdbc = new MssqlJdbcConverter();
            try {
                String schema = (String)new QueryRunner().query(conn, "SELECT SCHEMA_NAME()", (ResultSetHandler)new ScalarHandler());
                geomToJdbc.setSchema(schema);
            }
            catch (SQLException ex) {
                throw new UnsupportedOperationException("Cannot get/set schema: " + databaseProductName, ex);
            }
            return geomToJdbc;
        }
        if (databaseProductName.contains("HSQL Database Engine")) {
            return new HSQLJdbcConverter();
        }
        throw new UnsupportedOperationException("Unknown database: " + databaseProductName);
    }
}

