/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.datasource;

import com.vividsolutions.jump.coordsys.CoordinateSystem;
import com.vividsolutions.jump.coordsys.CoordinateSystemRegistry;
import com.vividsolutions.jump.io.datasource.DataSource;
import com.vividsolutions.jump.io.datasource.DataSourceQuery;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.util.LangUtil;
import com.vividsolutions.jump.workbench.datasource.DataSourceQueryChooser;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicFileChooserUI;

public abstract class FileDataSourceQueryChooser
implements DataSourceQueryChooser {
    private String description;
    private Class dataSourceClass;
    private FileFilter fileFilter;
    private JPanel southComponent1 = new JPanel();
    private JPanel southComponent2 = new JPanel();

    public FileDataSourceQueryChooser(Class dataSourceClass, String description, String[] extensions) {
        this.dataSourceClass = dataSourceClass;
        this.description = description;
        this.fileFilter = GUIUtil.createFileFilter(description, extensions);
    }

    public String toString() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInputValid() {
        final Boolean[] actionPerformed = new Boolean[]{Boolean.FALSE};
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                actionPerformed[0] = Boolean.TRUE;
            }
        };
        this.getFileChooserPanel().getChooser().addActionListener(listener);
        try {
            if (this.getFileChooserPanel().getChooser().getUI() instanceof BasicFileChooserUI) {
                BasicFileChooserUI ui = (BasicFileChooserUI)this.getFileChooserPanel().getChooser().getUI();
                ui.getApproveSelectionAction().actionPerformed(null);
            }
        }
        finally {
            this.getFileChooserPanel().getChooser().removeActionListener(listener);
        }
        return actionPerformed[0] == Boolean.TRUE;
    }

    public Collection getDataSourceQueries() {
        ArrayList queries = new ArrayList();
        File[] files = GUIUtil.selectedFiles(this.getFileChooserPanel().getChooser());
        for (int i = 0; i < files.length; ++i) {
            queries.addAll(this.toDataSourceQueries(files[i]));
        }
        return queries;
    }

    protected Collection toDataSourceQueries(File file) {
        return Collections.singleton(this.toDataSourceQuery(file));
    }

    protected abstract FileChooserPanel getFileChooserPanel();

    public Component getComponent() {
        this.setFileFilters();
        if (this.getFileChooserPanel().getSouthComponent1() != this.getSouthComponent1()) {
            this.getFileChooserPanel().setSouthComponent1(this.getSouthComponent1());
        }
        if (this.getFileChooserPanel().getSouthComponent2() != this.getSouthComponent2()) {
            this.getFileChooserPanel().setSouthComponent2(this.getSouthComponent2());
        }
        this.getFileChooserPanel().revalidate();
        this.getFileChooserPanel().repaint();
        return this.getFileChooserPanel();
    }

    private void setFileFilters() {
        Object[] filters = this.getFileChooserPanel().getChooser().getChoosableFileFilters();
        if (!CollectionUtil.containsReference(filters, this.getFileFilter())) {
            GUIUtil.removeChoosableFileFilters(this.getFileChooserPanel().getChooser());
            this.addFileFilters(this.getFileChooserPanel().getChooser());
            this.getFileChooserPanel().getChooser().setFileFilter(this.getFileFilter());
        }
    }

    protected void addFileFilters(JFileChooser chooser) {
        chooser.addChoosableFileFilter(this.getFileFilter());
        chooser.addChoosableFileFilter(chooser.getAcceptAllFileFilter());
    }

    protected DataSourceQuery toDataSourceQuery(File file) {
        DataSource dataSource = (DataSource)LangUtil.newInstance(this.dataSourceClass);
        dataSource.setProperties(this.toProperties(file));
        return new DataSourceQuery(dataSource, null, GUIUtil.nameWithoutExtension(file));
    }

    protected Map toProperties(File file) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("File", file.getPath());
        properties.put("Coordinate System", this.getFileChooserPanel().getSelectedCoordinateSystem().getName());
        return properties;
    }

    public static void main(String[] args) {
        JFileChooser chooser = new JFileChooser();
        JFrame f = new JFrame();
        f.getContentPane().add(chooser);
        f.pack();
        f.setVisible(true);
    }

    private FileFilter getFileFilter() {
        return this.fileFilter;
    }

    protected Component getSouthComponent1() {
        return this.southComponent1;
    }

    protected Component getSouthComponent2() {
        return this.southComponent2;
    }

    protected static class FileChooserPanel
    extends JPanel {
        private JFileChooser chooser;
        private Component southComponent1;
        private Component southComponent2;
        private JComboBox coordinateSystemComboBox = new JComboBox();
        private JLabel coordinateSystemLabel = new JLabel("Coordinate system of file: "){
            {
                this.setDisplayedMnemonic('r');
                this.setLabelFor(FileChooserPanel.this.coordinateSystemComboBox);
            }
        };
        private JPanel southComponent1Container = new JPanel(new BorderLayout());
        private JPanel southComponent2Container = new JPanel(new BorderLayout());

        public FileChooserPanel(JFileChooser chooser, Blackboard blackboard) {
            this.setLayout(new BorderLayout());
            this.coordinateSystemComboBox.setModel(new DefaultComboBoxModel(new Vector(CoordinateSystemRegistry.instance(blackboard).getCoordinateSystems())));
            this.chooser = chooser;
            JPanel southPanel = new JPanel(new GridBagLayout());
            southPanel.add((Component)this.coordinateSystemLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            southPanel.add((Component)this.coordinateSystemComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            southPanel.add((Component)this.southComponent1Container, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 4, 0, 0), 0, 0));
            southPanel.add((Component)this.southComponent2Container, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)chooser, "Center");
            this.add((Component)southPanel, "South");
            this.coordinateSystemComboBox.setVisible(false);
            this.coordinateSystemLabel.setVisible(false);
            this.setSouthComponent1(new JPanel());
            this.setSouthComponent2(new JPanel());
        }

        private void setSouthComponent1(Component southComponent1) {
            this.southComponent1Container.removeAll();
            this.southComponent1 = southComponent1;
            this.southComponent1Container.add(southComponent1, "Center");
        }

        private void setSouthComponent2(Component southComponent2) {
            this.southComponent2Container.removeAll();
            this.southComponent2 = southComponent2;
            this.southComponent2Container.add(southComponent2, "Center");
        }

        public JFileChooser getChooser() {
            return this.chooser;
        }

        private Component getSouthComponent1() {
            return this.southComponent1;
        }

        private Component getSouthComponent2() {
            return this.southComponent2;
        }

        public void setCoordinateSystemComboBoxVisible(boolean visible) {
            this.coordinateSystemComboBox.setVisible(visible);
            this.coordinateSystemLabel.setVisible(visible);
        }

        public CoordinateSystem getSelectedCoordinateSystem() {
            return this.coordinateSystemComboBox.isVisible() ? (CoordinateSystem)this.coordinateSystemComboBox.getSelectedItem() : CoordinateSystem.UNSPECIFIED;
        }

        public void setSelectedCoordinateSystem(String name) {
            this.coordinateSystemComboBox.setSelectedItem(this.coordinateSystem(name));
        }

        private CoordinateSystem coordinateSystem(String name) {
            for (int i = 0; i < this.coordinateSystemComboBox.getItemCount(); ++i) {
                if (!((CoordinateSystem)this.coordinateSystemComboBox.getItemAt(i)).getName().equals(name)) continue;
                return (CoordinateSystem)this.coordinateSystemComboBox.getItemAt(i);
            }
            return null;
        }
    }
}

