/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.datasource;

import com.vividsolutions.jump.io.datasource.StandardReaderWriterFileDataSource;
import com.vividsolutions.jump.workbench.datasource.DataSourceQueryChooserManager;
import com.vividsolutions.jump.workbench.datasource.InstallStandardDataSourceQueryChoosersPlugIn;
import com.vividsolutions.jump.workbench.datasource.LoadFileDataSourceQueryChooser;
import com.vividsolutions.jump.workbench.datasource.SaveFileDataSourceQueryChooser;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.ErrorHandler;
import com.vividsolutions.jump.workbench.ui.FileNamePanel;
import java.awt.Component;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class GMLDataSourceQueryChooserInstaller {
    private static final String GML_DESCRIPTION = "GML 2.0";

    public void addSaveGMLFileDataSourceQueryChooser(final PlugInContext context) {
        DataSourceQueryChooserManager.get(context.getWorkbenchContext().getBlackboard()).addSaveDataSourceQueryChooser(new SaveFileDataSourceQueryChooser(StandardReaderWriterFileDataSource.GML.class, GML_DESCRIPTION, InstallStandardDataSourceQueryChoosersPlugIn.extensions(StandardReaderWriterFileDataSource.GML.class), context.getWorkbenchContext()){
            private FileNamePanel templateFileNamePanel;

            public boolean isInputValid() {
                return GMLDataSourceQueryChooserInstaller.this.isValid(this.getTemplateFileNamePanel()) && super.isInputValid();
            }

            protected Map toProperties(File file) {
                HashMap<String, String> properties = new HashMap<String, String>(super.toProperties(file));
                properties.put("Output Template File", this.getTemplateFileNamePanel().getSelectedFile().getPath());
                return properties;
            }

            private FileNamePanel getTemplateFileNamePanel() {
                if (this.templateFileNamePanel == null) {
                    this.templateFileNamePanel = GMLDataSourceQueryChooserInstaller.this.createTemplateFileNamePanel("Output Template: ", this.getFileChooserPanel().getChooser(), context.getErrorHandler());
                }
                return this.templateFileNamePanel;
            }

            protected Component getSouthComponent1() {
                return this.getTemplateFileNamePanel();
            }
        });
    }

    private boolean isValid(FileNamePanel templateFileNamePanel) {
        if (!templateFileNamePanel.isInputValid()) {
            JOptionPane.showMessageDialog(SwingUtilities.windowForComponent(templateFileNamePanel), "Template File: " + templateFileNamePanel.getValidationError(), "Error", 0);
            return false;
        }
        return true;
    }

    public void addLoadGMLFileDataSourceQueryChooser(final PlugInContext context) {
        DataSourceQueryChooserManager.get(context.getWorkbenchContext().getBlackboard()).addLoadDataSourceQueryChooser(new LoadFileDataSourceQueryChooser(StandardReaderWriterFileDataSource.GML.class, GML_DESCRIPTION, InstallStandardDataSourceQueryChoosersPlugIn.extensions(StandardReaderWriterFileDataSource.GML.class), context.getWorkbenchContext()){
            private FileNamePanel templateFileNamePanel;

            protected void addFileFilters(JFileChooser chooser) {
                super.addFileFilters(chooser);
                InstallStandardDataSourceQueryChoosersPlugIn.addCompressedFileFilter(GMLDataSourceQueryChooserInstaller.GML_DESCRIPTION, chooser);
            }

            public boolean isInputValid() {
                return GMLDataSourceQueryChooserInstaller.this.isValid(this.getTemplateFileNamePanel()) && super.isInputValid();
            }

            protected Map toProperties(File file) {
                HashMap<String, String> properties = new HashMap<String, String>(super.toProperties(file));
                properties.put("Input Template File", this.getTemplateFileNamePanel().getSelectedFile().getPath());
                return properties;
            }

            private FileNamePanel getTemplateFileNamePanel() {
                if (this.templateFileNamePanel == null) {
                    this.templateFileNamePanel = GMLDataSourceQueryChooserInstaller.this.createTemplateFileNamePanel("Input Template: ", this.getFileChooserPanel().getChooser(), context.getErrorHandler());
                }
                return this.templateFileNamePanel;
            }

            protected Component getSouthComponent1() {
                return this.getTemplateFileNamePanel();
            }
        });
    }

    private FileNamePanel createTemplateFileNamePanel(String description, final JFileChooser fileChooser, ErrorHandler errorHandler) {
        return new TemplateFileNamePanel("Input Template: ", errorHandler){
            {
                super(x0, x1);
                this.setFileMustExist(true);
            }

            protected File getInitialFile() {
                File initialFile = super.getInitialFile();
                if (!(initialFile.exists() || initialFile.getParent() != null && initialFile.getParentFile().exists())) {
                    return fileChooser.getCurrentDirectory();
                }
                return initialFile;
            }
        };
    }

    private class TemplateFileNamePanel
    extends FileNamePanel {
        public TemplateFileNamePanel(String description, ErrorHandler errorHandler) {
            super(errorHandler);
            this.setUpperDescription("");
            this.setLeftDescription(description);
        }
    }
}

