/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.datasource;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.coordsys.CoordinateSystemRegistry;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.io.datasource.Connection;
import com.vividsolutions.jump.io.datasource.DataSourceQuery;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datasource.DataSourceQueryChooserDialog;
import com.vividsolutions.jump.workbench.datasource.DataSourceQueryChooserManager;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedBasePlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class LoadDatasetPlugIn
extends ThreadedBasePlugIn {
    private static String LAST_FORMAT_KEY = LoadDatasetPlugIn.class.getName() + " - LAST FORMAT";

    private DataSourceQueryChooserDialog getDialog(PlugInContext context) {
        String KEY = this.getClass().getName() + " - DIALOG";
        if (null == context.getWorkbenchContext().getWorkbench().getBlackboard().get(KEY)) {
            context.getWorkbenchContext().getWorkbench().getBlackboard().put(KEY, new DataSourceQueryChooserDialog(DataSourceQueryChooserManager.get(context.getWorkbenchContext().getWorkbench().getBlackboard()).getLoadDataSourceQueryChoosers(), context.getWorkbenchFrame(), this.getName(), true));
        }
        return (DataSourceQueryChooserDialog)context.getWorkbenchContext().getWorkbench().getBlackboard().get(KEY);
    }

    public String getName() {
        return "Load Dataset(s)";
    }

    public void initialize(final PlugInContext context) throws Exception {
        context.getWorkbenchFrame().addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                String format = (String)PersistentBlackboardPlugIn.get(context.getWorkbenchContext()).get(LAST_FORMAT_KEY);
                if (format != null) {
                    LoadDatasetPlugIn.this.getDialog(context).setSelectedFormat(format);
                }
            }
        });
    }

    public boolean execute(PlugInContext context) throws Exception {
        GUIUtil.centreOnWindow(this.getDialog(context));
        this.getDialog(context).setVisible(true);
        if (this.getDialog(context).wasOKPressed()) {
            PersistentBlackboardPlugIn.get(context.getWorkbenchContext()).put(LAST_FORMAT_KEY, this.getDialog(context).getSelectedFormat());
        }
        return this.getDialog(context).wasOKPressed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        Collection dataSourceQueries = this.getDialog(context).getCurrentChooser().getDataSourceQueries();
        Assert.isTrue((!dataSourceQueries.isEmpty() ? 1 : 0) != 0);
        boolean exceptionsEncountered = false;
        for (DataSourceQuery dataSourceQuery : dataSourceQueries) {
            ArrayList exceptions = new ArrayList();
            Assert.isTrue((boolean)dataSourceQuery.getDataSource().isReadable());
            monitor.report("Loading " + dataSourceQuery.toString() + "...");
            Connection connection = dataSourceQuery.getDataSource().getConnection();
            try {
                FeatureCollection dataset = dataSourceQuery.getDataSource().installCoordinateSystem(connection.executeQuery(dataSourceQuery.getQuery(), exceptions, monitor), CoordinateSystemRegistry.instance(context.getWorkbenchContext().getBlackboard()));
                if (dataset != null) {
                    context.getLayerManager().addLayer(this.chooseCategory(context), dataSourceQuery.toString(), dataset).setDataSourceQuery(dataSourceQuery).setFeatureCollectionModified(false);
                }
            }
            finally {
                connection.close();
            }
            if (exceptions.isEmpty()) continue;
            if (!exceptionsEncountered) {
                context.getOutputFrame().createNewDocument();
                exceptionsEncountered = true;
            }
            this.reportExceptions(exceptions, dataSourceQuery, context);
        }
        if (exceptionsEncountered) {
            context.getWorkbenchFrame().warnUser("Problems were encountered. See Output Window for details.");
        }
    }

    private void reportExceptions(ArrayList exceptions, DataSourceQuery dataSourceQuery, PlugInContext context) {
        context.getOutputFrame().addHeader(1, exceptions.size() + " problem" + StringUtil.s(exceptions.size()) + " loading " + dataSourceQuery.toString() + "." + (exceptions.size() > 10 ? " First and last five:" : ""));
        context.getOutputFrame().addText("See View / Log for stack traces");
        context.getOutputFrame().append("<ul>");
        ArrayList exceptionsToReport = exceptions.size() <= 10 ? exceptions : CollectionUtil.concatenate(Arrays.asList(exceptions.subList(0, 5), exceptions.subList(exceptions.size() - 5, exceptions.size())));
        for (Exception exception : exceptionsToReport) {
            context.getWorkbenchFrame().log(StringUtil.stackTrace(exception));
            context.getOutputFrame().append("<li>");
            context.getOutputFrame().append(GUIUtil.escapeHTML(WorkbenchFrame.toMessage(exception), true, true));
            context.getOutputFrame().append("</li>");
        }
        context.getOutputFrame().append("</ul>");
    }

    private String chooseCategory(PlugInContext context) {
        return context.getLayerNamePanel().getSelectedCategories().isEmpty() ? "Working" : context.getLayerNamePanel().getSelectedCategories().iterator().next().toString();
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerManagerMustBeActiveCheck());
    }
}

