/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model;

import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.Layerable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;

public class Task
implements LayerManagerProxy {
    private String name = "";
    private ArrayList nameListeners = new ArrayList();
    private File projectFile = null;
    private LayerManager layerManager = new LayerManager();

    public void add(NameListener nameListener) {
        this.nameListeners.add(nameListener);
    }

    public void setName(String name) {
        this.name = name;
        this.fireNameChanged(name);
    }

    public void setProjectFile(File projectFile) {
        this.projectFile = projectFile;
    }

    public LayerManager getLayerManager() {
        return this.layerManager;
    }

    public File getProjectFile() {
        return this.projectFile;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    private void fireNameChanged(String name) {
        for (NameListener nameListener : this.nameListeners) {
            nameListener.taskNameChanged(name);
        }
    }

    public Collection getCategories() {
        return this.getLayerManager().getCategories();
    }

    public void addCategory(Category category) {
        this.getLayerManager().addCategory(category.getName());
        Category actual = this.getLayerManager().getCategory(category.getName());
        for (Layerable layerable : category.getLayerables()) {
            actual.addPersistentLayerable(layerable);
        }
    }

    public static interface NameListener {
        public void taskNameChanged(String var1);
    }
}

