/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import java.awt.Color;
import java.util.Collection;
import java.util.Map;

public class FeatureInfoWriter {
    public static Writer ATTRIBUTE_WRITER = new Writer(){

        public String toHTML(Feature feature) {
            StringBuffer s = new StringBuffer();
            for (int i = 0; i < feature.getSchema().getAttributeCount(); ++i) {
                if (feature.getAttribute(i) instanceof Geometry) continue;
                s.append("<br><b>" + GUIUtil.escapeHTML(feature.getSchema().getAttributeName(i), false, false) + ":</b> ");
                if (feature.getAttribute(i) == null) continue;
                s.append(GUIUtil.escapeHTML(feature.getAttribute(i).toString(), false, false));
            }
            return s.toString();
        }
    };
    public static Writer EMPTY_WRITER = new Writer(){

        public String toHTML(Feature feature) {
            return "";
        }
    };
    private static final String BEIGE = "#E6E6E6";
    private static final String WHITE = "#FFFFFF";
    private static final String COLOR1 = "#E6E6E6";
    private static final String COLOR2 = "#FFFFFF";
    private boolean workingAroundJEditorPaneBug = true;

    public Color sidebarColor(Layer layer) {
        Color basicColor = layer.getBasicStyle().isRenderingFill() ? layer.getBasicStyle().getFillColor() : layer.getBasicStyle().getLineColor();
        int alpha = layer.getBasicStyle().getAlpha();
        return GUIUtil.toSimulatedTransparency(GUIUtil.alphaColor(basicColor, alpha));
    }

    public String writeGeom(Map layerToFeaturesMap, Writer featureWriter, Writer attributeWriter) {
        if (layerToFeaturesMap.isEmpty()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (Layer layer : layerToFeaturesMap.keySet()) {
            Collection features = (Collection)layerToFeaturesMap.get(layer);
            stringBuffer.append("<table width=100%>");
            stringBuffer.append("  <tr>");
            stringBuffer.append("    <td width=5 bgcolor=" + this.toHTML(this.sidebarColor(layer)) + ">");
            stringBuffer.append("    </td>");
            stringBuffer.append("    <td width=100%>");
            stringBuffer.append("      <table width=100%>");
            stringBuffer.append("        <tr>");
            stringBuffer.append("          <td bgcolor=#FFFFCC>");
            stringBuffer.append("            <B>" + layer.getName() + "</B>");
            stringBuffer.append("          </td>");
            stringBuffer.append("        </tr>");
            String bgcolor = "#E6E6E6";
            for (Feature feature : features) {
                bgcolor = !bgcolor.equals("#E6E6E6") ? "#E6E6E6" : "#FFFFFF";
                stringBuffer.append("        <tr bgcolor='" + bgcolor + "'>");
                stringBuffer.append("          <td>");
                stringBuffer.append("            FID <font color='#3300cc'><b>" + feature.getID() + "</b></font>");
                if (featureWriter != EMPTY_WRITER) {
                    this.append(feature, stringBuffer, featureWriter);
                }
                if (attributeWriter != EMPTY_WRITER) {
                    stringBuffer.append("            " + attributeWriter.toHTML(feature));
                }
                stringBuffer.append("          </td>");
                stringBuffer.append("        </tr>");
            }
            stringBuffer.append("      </table>");
            stringBuffer.append("    </td>");
            stringBuffer.append("  </tr>");
            stringBuffer.append("</table>");
        }
        return stringBuffer.toString();
    }

    private String pad(String s) {
        return s.length() == 1 ? "0" + s : s;
    }

    private String toHTML(Color color) {
        String colorString = "#";
        colorString = colorString + this.pad(Integer.toHexString(color.getRed()));
        colorString = colorString + this.pad(Integer.toHexString(color.getGreen()));
        colorString = colorString + this.pad(Integer.toHexString(color.getBlue()));
        return colorString;
    }

    private void append(Feature feature, StringBuffer stringBuffer, Writer featureWriter) {
        String text = featureWriter.toHTML(feature);
        if (this.workingAroundJEditorPaneBug && stringBuffer.length() + featureWriter.toHTML(feature).length() > 30768) {
            text = "The text representation of this geometry is too large for this view.";
        }
        stringBuffer.append(text);
    }

    public static interface Writer {
        public String toHTML(Feature var1);
    }
}

