/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

public class LeftClickFilter
implements CursorTool {
    private CursorTool wrappee;

    public LeftClickFilter(CursorTool wrappee) {
        this.wrappee = wrappee;
    }

    public CursorTool getWrappee() {
        return this.wrappee;
    }

    public Icon getIcon() {
        return this.wrappee.getIcon();
    }

    public String getName() {
        return this.wrappee.getName();
    }

    public Cursor getCursor() {
        return this.wrappee.getCursor();
    }

    public void activate(LayerViewPanel panel) {
        this.wrappee.activate(panel);
    }

    public void deactivate() {
        this.wrappee.deactivate();
    }

    public void mouseClicked(MouseEvent e) {
        if (this.isOnlyLeftMouseButton(e)) {
            this.wrappee.mouseClicked(e);
        }
    }

    public void mousePressed(MouseEvent e) {
        if (this.isOnlyLeftMouseButton(e)) {
            this.wrappee.mousePressed(e);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.isOnlyLeftMouseButton(e)) {
            this.wrappee.mouseReleased(e);
        }
    }

    public void mouseEntered(MouseEvent e) {
        this.wrappee.mouseEntered(e);
    }

    public void mouseExited(MouseEvent e) {
        this.wrappee.mouseExited(e);
    }

    public void mouseDragged(MouseEvent e) {
        if (this.isOnlyLeftMouseButton(e)) {
            this.wrappee.mouseDragged(e);
        }
    }

    public void mouseMoved(MouseEvent e) {
        this.wrappee.mouseMoved(e);
    }

    public boolean isRightMouseButtonUsed() {
        return false;
    }

    public boolean isGestureInProgress() {
        return this.wrappee.isGestureInProgress();
    }

    public void cancelGesture() {
        this.wrappee.cancelGesture();
    }

    private boolean isOnlyLeftMouseButton(MouseEvent e) {
        return SwingUtilities.isLeftMouseButton(e) && !SwingUtilities.isRightMouseButton(e);
    }
}

