/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.model.FeatureEventType;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.cursortool.NClickTool;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.renderer.style.Style;
import com.vividsolutions.jump.workbench.ui.snap.SnapToFeaturesPolicy;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class NoteTool
extends NClickTool {
    private JTextArea textArea;
    private Mode mode;
    private static final int WIDTH = 80;
    private static final int HEIGHT = 30;
    private ImageIcon icon = IconLoader.icon("sticky.png");
    private Cursor cursor = GUIUtil.createCursorFromIcon(this.icon.getImage());

    public NoteTool() {
        super(1);
        this.getSnapManager().addPolicies(Collections.singleton(new SnapToFeaturesPolicy()));
        this.textArea = NoteTool.createTextArea();
        this.textArea.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                NoteTool.this.removeTextAreaFromPanel();
            }
        });
    }

    public void deactivate() {
        this.removeTextAreaFromPanel();
        super.deactivate();
    }

    private static JTextArea createTextArea() {
        return new JTextArea(){
            {
                this.setFont(new JLabel().getFont());
                this.setLineWrap(true);
                this.setWrapStyleWord(true);
                this.setBorder(BorderFactory.createLineBorder(Color.lightGray));
            }
        };
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void gestureFinished() throws Exception {
        this.reportNothingToUndoYet();
        Feature noteFeatureAtClick = this.noteFeature(this.getModelDestination());
        try {
            if (this.panelContainsTextArea() && noteFeatureAtClick == null) {
                return;
            }
        }
        finally {
            this.removeTextAreaFromPanel();
        }
        this.mode = this.mode(noteFeatureAtClick, this.getModelDestination());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    NoteTool.this.addTextAreaToPanel(NoteTool.this.mode.location());
                }
                catch (NoninvertibleTransformException e) {
                    NoteTool.this.getPanel().getContext().handleThrowable(e);
                }
            }
        });
    }

    private Mode mode(Feature noteFeatureAtClick, Coordinate click) {
        return noteFeatureAtClick == null ? new CreateMode(click) : new EditMode(noteFeatureAtClick);
    }

    private Feature noteFeature(Coordinate click) {
        return this.noteFeature(new Envelope(click, new Coordinate(click.x - 80.0 / this.scale(), click.y + 30.0 / this.scale())));
    }

    private Feature noteFeature(Envelope envelope) {
        return (Feature)this.firstOrNull(this.layer().getFeatureCollectionWrapper().query(envelope));
    }

    private Object firstOrNull(Collection items) {
        return !items.isEmpty() ? items.iterator().next() : null;
    }

    private double scale() {
        return this.getPanel().getViewport().getScale();
    }

    private void addTextAreaToPanel(Coordinate location) throws NoninvertibleTransformException {
        this.layer().setVisible(true);
        if (this.getPanel().getLayout() != null) {
            this.getPanel().setLayout(null);
        }
        this.textArea.setText(this.mode.initialText());
        this.textArea.setBackground(this.layer().getBasicStyle().getFillColor());
        this.getPanel().add(this.textArea);
        this.textArea.setBounds((int)this.getPanel().getViewport().toViewPoint(location).getX(), (int)this.getPanel().getViewport().toViewPoint(location).getY(), 80, 30);
        this.textArea.requestFocus();
    }

    private boolean panelContainsTextArea() {
        return Arrays.asList(this.getPanel().getComponents()).contains(this.textArea);
    }

    private void removeTextAreaFromPanel() {
        if (!this.panelContainsTextArea()) {
            return;
        }
        this.mode.commit(this.textArea.getText().trim());
        this.getPanel().remove(this.textArea);
        this.getPanel().superRepaint();
    }

    private void disableAutomaticInitialZooming() {
        this.getPanel().setViewportInitialized(true);
    }

    private Layer layer() {
        String name = "Notes";
        if (this.getPanel().getLayerManager().getLayer("Notes") != null) {
            return this.getPanel().getLayerManager().getLayer("Notes");
        }
        return new Layer("Notes", Color.yellow.brighter().brighter(), new FeatureDataset(new FeatureSchema(){
            {
                this.addAttribute("CREATED", AttributeType.DATE);
                this.addAttribute("MODIFIED", AttributeType.DATE);
                this.addAttribute("TEXT", AttributeType.STRING);
                this.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
            }
        }), this.getPanel().getLayerManager()){
            {
                this.getLayerManager().deferFiringEvents(new Runnable(){

                    public void run() {
                        this.getBasicStyle().setAlpha(150);
                        this.addStyle(this.createStyle());
                        this.setDrawingLast(true);
                    }
                });
                this.getLayerManager().addLayer("System", this);
            }

            private Style createStyle() {
                return new NoteStyle();
            }
        };
    }

    public Icon getIcon() {
        return this.icon;
    }

    protected Shape getShape() throws NoninvertibleTransformException {
        return null;
    }

    static /* synthetic */ JTextArea access$700() {
        return NoteTool.createTextArea();
    }

    public static class NoteStyle
    implements Style {
        private JTextArea myTextArea = NoteTool.access$700();
        private Layer layer;

        public void paint(Feature f, Graphics2D g, Viewport viewport) throws Exception {
            this.paint(f, viewport.toViewPoint(f.getGeometry().getCoordinate()), g);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void paint(Feature f, Point2D location, Graphics2D g) {
            this.myTextArea.setText(f.getString("TEXT"));
            this.myTextArea.setBounds(0, 0, 80, 30);
            Composite originalComposite = g.getComposite();
            g.translate(location.getX(), location.getY());
            try {
                g.setComposite(AlphaComposite.getInstance(3, (float)this.layer.getBasicStyle().getAlpha() / 255.0f));
                this.myTextArea.paint(g);
            }
            finally {
                g.setComposite(originalComposite);
                g.translate(-location.getX(), -location.getY());
            }
        }

        public void initialize(Layer layer) {
            this.layer = layer;
            this.myTextArea.setBackground(layer.getBasicStyle().getFillColor());
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                Assert.shouldNeverReachHere();
                return null;
            }
        }

        public void setEnabled(boolean enabled) {
            throw new UnsupportedOperationException();
        }

        public boolean isEnabled() {
            return true;
        }
    }

    private class EditMode
    extends Mode {
        public EditMode(Feature noteFeature) {
            super(noteFeature);
        }

        public void commit(final String text) {
            final Date modifiedDate = new Date();
            final Date oldModifiedDate = (Date)this.getNoteFeature().getAttribute("MODIFIED");
            final String oldText = this.getNoteFeature().getString("TEXT");
            NoteTool.this.execute(new UndoableCommand(NoteTool.this.getName()){

                public void execute() {
                    EditMode.this.update(EditMode.this.getNoteFeature(), text, modifiedDate, NoteTool.this.layer());
                }

                public void unexecute() {
                    EditMode.this.update(EditMode.this.getNoteFeature(), oldText, oldModifiedDate, NoteTool.this.layer());
                }
            });
        }

        private void update(Feature noteFeature, String text, Date modifiedDate, Layer layer) {
            noteFeature.setAttribute("MODIFIED", (Object)modifiedDate);
            noteFeature.setAttribute("TEXT", (Object)text);
            layer.getLayerManager().fireFeaturesChanged(Collections.singleton(noteFeature), FeatureEventType.ATTRIBUTES_MODIFIED, layer);
        }

        public String initialText() {
            return this.getNoteFeature().getString("TEXT");
        }
    }

    private class CreateMode
    extends Mode {
        public CreateMode(final Coordinate location) {
            super(new BasicFeature(NoteTool.this.layer().getFeatureCollectionWrapper().getFeatureSchema()){
                {
                    super(x0);
                    this.setAttribute("CREATED", (Object)new Date());
                    this.setAttribute("GEOMETRY", (Object)new GeometryFactory().createPoint(location));
                }
            });
        }

        public void commit(String text) {
            if (text.length() > 0) {
                NoteTool.this.disableAutomaticInitialZooming();
                this.getNoteFeature().setAttribute("MODIFIED", (Object)new Date());
                this.getNoteFeature().setAttribute("TEXT", (Object)text);
                EditTransaction transaction = new EditTransaction((Collection)Collections.EMPTY_LIST, NoteTool.this.getName(), NoteTool.this.layer(), NoteTool.this.isRollingBackInvalidEdits(), true, NoteTool.this.getPanel());
                transaction.createFeature(this.getNoteFeature());
                transaction.commit();
            }
        }

        public String initialText() {
            return "";
        }
    }

    private abstract class Mode {
        private Feature noteFeature;

        public Mode(Feature noteFeature) {
            this.noteFeature = noteFeature;
        }

        public Coordinate location() {
            return this.noteFeature.getGeometry().getCoordinate();
        }

        public abstract void commit(String var1);

        protected Feature getNoteFeature() {
            return this.noteFeature;
        }

        public abstract String initialText();
    }
}

