/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.warp.Triangulator;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelContext;
import com.vividsolutions.jump.workbench.ui.plugin.clipboard.PasteItemsPlugIn;
import com.vividsolutions.jump.workbench.ui.warp.WarpingVectorLayerFinder;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComponent;

public class CopySelectedLayersToWarpingVectorsPlugIn
extends AbstractPlugIn {
    public EnableCheck createEnableCheck(final WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createTaskWindowMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustBeSelectedCheck(1)).add(new EnableCheck(){

            public String check(JComponent component) {
                return workbenchContext.getLayerNamePanel().getSelectedLayers().length == 1 && workbenchContext.getLayerNamePanel().getSelectedLayers()[0] == new WarpingVectorLayerFinder(workbenchContext).getLayer() ? "A layer other than '" + new WarpingVectorLayerFinder(workbenchContext).getLayerName() + "' must be selected" : null;
            }
        });
    }

    public static Collection removeNonVectorFeaturesAndWarn(Collection features, LayerViewPanelContext context) {
        ArrayList newFeatures = new ArrayList(features);
        Collection nonVectorFeatures = CopySelectedLayersToWarpingVectorsPlugIn.nonVectorFeatures(newFeatures);
        if (!nonVectorFeatures.isEmpty()) {
            context.warnUser("Skipped " + nonVectorFeatures.size() + " non-two-point-linestring" + StringUtil.s(nonVectorFeatures.size()) + " e.g. " + ((Feature)nonVectorFeatures.iterator().next()).getGeometry().toText());
            newFeatures.removeAll(nonVectorFeatures);
        }
        return newFeatures;
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        Collection newWarpingVectors = new ArrayList();
        Layer[] selectedLayers = context.getSelectedLayers();
        for (int i = 0; i < selectedLayers.length; ++i) {
            if (selectedLayers[i] == new WarpingVectorLayerFinder(context).getLayer()) continue;
            newWarpingVectors.addAll(selectedLayers[i].getFeatureCollectionWrapper().getFeatures());
        }
        final Collection finalNewWarpingVectors = newWarpingVectors = CopySelectedLayersToWarpingVectorsPlugIn.removeNonVectorFeaturesAndWarn(newWarpingVectors, context.getWorkbenchFrame());
        final WarpingVectorLayerFinder finder = new WarpingVectorLayerFinder(context);
        this.execute(Layer.addUndo(finder.getLayerName(), context, new UndoableCommand(this.getName()){

            public void execute() {
                if (finder.getLayer() == null) {
                    finder.createLayer();
                }
                finder.getLayer().getFeatureCollectionWrapper().addAll(PasteItemsPlugIn.conform(finalNewWarpingVectors, finder.getLayer().getFeatureCollectionWrapper().getFeatureSchema()));
            }

            public void unexecute() {
            }
        }), context);
        return true;
    }

    private static Collection nonVectorFeatures(Collection candidates) {
        ArrayList<Feature> nonVectorFeatures = new ArrayList<Feature>();
        for (Feature candidate : candidates) {
            if (Triangulator.vector(candidate.getGeometry())) continue;
            nonVectorFeatures.add(candidate);
        }
        return nonVectorFeatures;
    }
}

