/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.GeometryEditor;
import com.vividsolutions.jump.workbench.ui.SelectionManagerProxy;
import java.util.ArrayList;
import java.util.Collection;

public class DeleteSelectedItemsPlugIn
extends AbstractPlugIn {
    private GeometryEditor geometryEditor = new GeometryEditor();

    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        ArrayList<EditTransaction> transactions = new ArrayList<EditTransaction>();
        for (Layer layerWithSelectedItems : ((SelectionManagerProxy)((Object)context.getActiveInternalFrame())).getSelectionManager().getLayersWithSelectedItems()) {
            transactions.add(EditTransaction.createTransactionOnSelection(new EditTransaction.SelectionEditor(){

                public Geometry edit(Geometry geometryWithSelectedItems, Collection selectedItems) {
                    Geometry g = geometryWithSelectedItems;
                    for (Geometry selectedItem : selectedItems) {
                        g = DeleteSelectedItemsPlugIn.this.geometryEditor.remove(g, selectedItem);
                    }
                    return g;
                }
            }, (SelectionManagerProxy)((Object)context.getActiveInternalFrame()), context.getWorkbenchFrame(), this.getName(), layerWithSelectedItems, this.isRollingBackInvalidEdits(context), true));
        }
        return EditTransaction.commit(transactions);
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithSelectionManagerMustBeActiveCheck()).add(checkFactory.createAtLeastNItemsMustBeSelectedCheck(1)).add(checkFactory.createSelectedItemsLayersMustBeEditableCheck());
    }

    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        this.registerDeleteKey(context.getWorkbenchContext());
    }

    private void registerDeleteKey(WorkbenchContext context) {
        context.getWorkbench().getFrame().addKeyboardShortcut(127, 0, this, DeleteSelectedItemsPlugIn.createEnableCheck(context));
    }
}

