/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.coordsys.CoordinateSystemRegistry;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.io.datasource.Connection;
import com.vividsolutions.jump.io.datasource.DataSource;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.java2xml.XML2Java;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedBasePlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.plugin.SaveProjectAsPlugIn;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JFileChooser;

public class OpenProjectPlugIn
extends ThreadedBasePlugIn {
    private JFileChooser fileChooser;

    public String getName() {
        return "Open Task";
    }

    public void initialize(PlugInContext context) throws Exception {
        this.fileChooser = GUIUtil.createJFileChooserWithExistenceChecking();
        this.fileChooser.setDialogTitle("Open Task");
        this.fileChooser.setDialogType(0);
        this.fileChooser.setFileSelectionMode(0);
        this.fileChooser.setMultiSelectionEnabled(false);
        GUIUtil.removeChoosableFileFilters(this.fileChooser);
        this.fileChooser.addChoosableFileFilter(SaveProjectAsPlugIn.JUMP_PROJECT_FILE_FILTER);
        this.fileChooser.addChoosableFileFilter(GUIUtil.ALL_FILES_FILTER);
        this.fileChooser.setFileFilter(SaveProjectAsPlugIn.JUMP_PROJECT_FILE_FILTER);
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        return 0 == this.fileChooser.showOpenDialog(context.getWorkbenchFrame());
    }

    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        this.open(this.fileChooser.getSelectedFile(), context.getWorkbenchFrame(), monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void open(File file, WorkbenchFrame workbenchFrame, TaskMonitor monitor) throws Exception {
        monitor.report("Creating objects");
        FileReader reader = new FileReader(file);
        try {
            Task sourceTask = (Task)new XML2Java().read(reader, Task.class);
            Task newTask = new Task();
            newTask.setName(GUIUtil.nameWithoutExtension(file));
            newTask.setProjectFile(file);
            workbenchFrame.addTaskFrame(newTask);
            this.loadLayers(sourceTask.getLayerManager(), newTask.getLayerManager(), CoordinateSystemRegistry.instance(workbenchFrame.getContext().getBlackboard()), monitor);
        }
        finally {
            reader.close();
        }
    }

    private void loadLayers(LayerManager sourceLayerManager, LayerManager newLayerManager, CoordinateSystemRegistry registry, TaskMonitor monitor) throws Exception {
        for (Category sourceLayerCategory : sourceLayerManager.getCategories()) {
            newLayerManager.addCategory(sourceLayerCategory.getName());
            ArrayList layerables = new ArrayList(sourceLayerCategory.getLayerables());
            Collections.reverse(layerables);
            for (Layerable layerable : layerables) {
                monitor.report("Loading " + layerable.getName());
                layerable.setLayerManager(newLayerManager);
                if (layerable instanceof Layer) {
                    Layer layer = (Layer)layerable;
                    layer.setFeatureCollection(this.executeQuery(layer.getDataSourceQuery().getQuery(), layer.getDataSourceQuery().getDataSource(), registry, monitor));
                    layer.setFeatureCollectionModified(false);
                }
                newLayerManager.addLayerable(sourceLayerCategory.getName(), layerable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FeatureCollection executeQuery(String query, DataSource dataSource, CoordinateSystemRegistry registry, TaskMonitor monitor) throws Exception {
        Connection connection = dataSource.getConnection();
        try {
            FeatureCollection featureCollection = dataSource.installCoordinateSystem(connection.executeQuery(query, monitor), registry);
            return featureCollection;
        }
        finally {
            connection.close();
        }
    }
}

