/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.analysis;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureDatasetFactory;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.feature.IndexedFeatureCollection;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class GeometryFunctionPlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    private static final String LAYER1 = "Layer A";
    private static final String LAYER2 = "Layer B";
    private static final String METHODS = "Function";
    private static final String METHOD_INTERSECTION = "Intersection";
    private static final String METHOD_UNION = "Union";
    private static final String METHOD_DIFFERENCE_AB = "Difference (A-B)";
    private static final String METHOD_DIFFERENCE_BA = "Difference (B-A)";
    private static final String METHOD_SYMDIFF = "Symmetric Difference";
    private Collection geometryMethodNames = GeometryFunctionPlugIn.getGeometryMethodNames();
    private MultiInputDialog dialog;
    private Layer layer1;
    private Layer layer2;
    private String methodNameToRun;
    private boolean exceptionThrown = false;

    private static Collection getGeometryMethodNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(METHOD_INTERSECTION);
        names.add(METHOD_UNION);
        names.add(METHOD_DIFFERENCE_AB);
        names.add(METHOD_DIFFERENCE_BA);
        names.add(METHOD_SYMDIFF);
        return names;
    }

    public boolean execute(PlugInContext context) throws Exception {
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(dialog, context);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        return true;
    }

    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        FeatureSchema featureSchema = new FeatureSchema();
        featureSchema.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        FeatureCollection resultFC = new FeatureDataset(featureSchema);
        Collection resultColl = this.runGeometryMethod(this.layer1.getFeatureCollectionWrapper(), this.layer2.getFeatureCollectionWrapper(), this.methodNameToRun);
        resultFC = FeatureDatasetFactory.createFromGeometry(resultColl);
        context.addLayer("Working", "Result-" + this.methodNameToRun, resultFC);
        if (this.exceptionThrown) {
            context.getWorkbenchFrame().warnUser("Errors found while executing function");
        }
    }

    private Collection runGeometryMethod(FeatureCollection fcA, FeatureCollection fcB, String methodName) {
        this.exceptionThrown = false;
        ArrayList<Geometry> resultColl = new ArrayList<Geometry>();
        IndexedFeatureCollection index = new IndexedFeatureCollection(fcB);
        Iterator ia = fcA.iterator();
        while (ia.hasNext()) {
            Feature fa = (Feature)ia.next();
            Geometry ga = fa.getGeometry();
            List queryResult = index.query(ga.getEnvelopeInternal());
            for (Feature fb : queryResult) {
                Geometry gb = fb.getGeometry();
                Geometry result = this.runGeometryMethod(ga, gb, methodName);
                if (result == null) continue;
                resultColl.add(result);
            }
        }
        return resultColl;
    }

    private Geometry runGeometryMethod(Geometry a, Geometry b, String methodName) {
        Geometry result = null;
        try {
            if (methodName.equals(METHOD_INTERSECTION)) {
                result = a.intersection(b);
            } else if (methodName.equals(METHOD_UNION)) {
                result = a.union(b);
            } else if (methodName.equals(METHOD_DIFFERENCE_AB)) {
                result = a.difference(b);
            } else if (methodName.equals(METHOD_DIFFERENCE_BA)) {
                result = b.difference(a);
            } else if (methodName.equals(METHOD_SYMDIFF)) {
                result = a.symDifference(b);
            }
            return result;
        }
        catch (RuntimeException ex) {
            this.exceptionThrown = true;
            return null;
        }
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.setSideBarDescription("Computes a spatial function on all (pairs of) geometries from the input layer(s)");
        dialog.addLayerComboBox(LAYER1, this.layer1, context.getLayerManager());
        dialog.addLayerComboBox(LAYER2, this.layer2, context.getLayerManager());
        dialog.addComboBox(METHODS, this.methodNameToRun, this.geometryMethodNames, null);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.layer1 = dialog.getLayer(LAYER1);
        this.layer2 = dialog.getLayer(LAYER2);
        this.methodNameToRun = dialog.getText(METHODS);
    }
}

