/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.analysis;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.feature.FeatureDatasetFactory;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JComboBox;

public class UnionPlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    private static final String LAYER = "Layer";
    private MultiInputDialog dialog;

    public boolean execute(PlugInContext context) throws Exception {
        this.initDialog(context);
        this.dialog.setVisible(true);
        return this.dialog.wasOKPressed();
    }

    private void initDialog(PlugInContext context) {
        this.dialog = new MultiInputDialog(context.getWorkbenchFrame(), "Union", true);
        this.dialog.setSideBarDescription("Creates a new layer containing the union of all the features in the input layer");
        String fieldName = LAYER;
        JComboBox addLayerComboBox = this.dialog.addLayerComboBox(fieldName, context.getCandidateLayer(0), null, context.getLayerManager());
        GUIUtil.centreOnWindow(this.dialog);
    }

    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        FeatureCollectionWrapper a = this.dialog.getLayer(LAYER).getFeatureCollectionWrapper();
        FeatureCollection union = this.union(monitor, a);
        context.addLayer("Working", "Union", union);
    }

    private FeatureCollection union(TaskMonitor monitor, FeatureCollection fc) {
        monitor.allowCancellationRequests();
        monitor.report("Computing Union...");
        ArrayList<Geometry> unionGeometryList = new ArrayList<Geometry>();
        Geometry currUnion = null;
        int size = fc.size();
        int count = 1;
        Iterator i = fc.iterator();
        while (i.hasNext()) {
            Feature f = (Feature)i.next();
            Geometry geom = f.getGeometry();
            currUnion = currUnion == null ? geom : currUnion.union(geom);
            monitor.report(count++, size, "features");
        }
        unionGeometryList.add(currUnion);
        return FeatureDatasetFactory.createFromGeometry(unionGeometryList);
    }
}

