/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.clipboard;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jump.coordsys.Reprojector;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.io.WKTReader;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.plugin.clipboard.CollectionOfFeaturesTransferable;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComponent;

public class PasteItemsPlugIn
extends AbstractPlugIn {
    private WKTReader reader = new WKTReader();

    public String getNameWithMnemonic() {
        return StringUtil.replace(this.getName(), "P", "&P", false);
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        Transferable transferable = GUIUtil.getContents(Toolkit.getDefaultToolkit().getSystemClipboard());
        Collection features = transferable.isDataFlavorSupported(CollectionOfFeaturesTransferable.COLLECTION_OF_FEATURES_FLAVOR) ? (Collection)GUIUtil.getContents(Toolkit.getDefaultToolkit().getSystemClipboard()).getTransferData(CollectionOfFeaturesTransferable.COLLECTION_OF_FEATURES_FLAVOR) : this.reader.read(new StringReader((String)transferable.getTransferData(DataFlavor.stringFlavor))).getFeatures();
        final Layer layer = context.getSelectedLayer(0);
        final Collection featureCopies = PasteItemsPlugIn.conform(features, layer.getFeatureCollectionWrapper().getFeatureSchema());
        this.execute(new UndoableCommand(this.getName()){

            public void execute() {
                layer.getFeatureCollectionWrapper().addAll(featureCopies);
            }

            public void unexecute() {
                layer.getFeatureCollectionWrapper().removeAll(featureCopies);
            }
        }, context);
        return true;
    }

    public static Collection conform(Collection features, FeatureSchema targetFeatureSchema) {
        ArrayList<Feature> featureCopies = new ArrayList<Feature>();
        for (Feature feature : features) {
            featureCopies.add(PasteItemsPlugIn.conform(feature, targetFeatureSchema));
        }
        return featureCopies;
    }

    private static Feature conform(Feature original, FeatureSchema targetFeatureSchema) {
        BasicFeature copy = new BasicFeature(targetFeatureSchema);
        copy.setGeometry((Geometry)original.getGeometry().clone());
        for (int i = 0; i < original.getSchema().getAttributeCount(); ++i) {
            if (i == original.getSchema().getGeometryIndex()) continue;
            String attributeName = original.getSchema().getAttributeName(i);
            if (!copy.getSchema().hasAttribute(attributeName) || copy.getSchema().getAttributeType(attributeName) != original.getSchema().getAttributeType(attributeName)) continue;
            copy.setAttribute(attributeName, original.getAttribute(attributeName));
        }
        Reprojector.instance().reproject(copy.getGeometry(), original.getSchema().getCoordinateSystem(), copy.getSchema().getCoordinateSystem());
        return copy;
    }

    public static MultiEnableCheck createEnableCheck(final WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createExactlyNLayersMustBeSelectedCheck(1)).add(checkFactory.createSelectedLayersMustBeEditableCheck()).add(new EnableCheck(){

            public String check(JComponent component) {
                Transferable transferable = GUIUtil.getContents(Toolkit.getDefaultToolkit().getSystemClipboard());
                if (transferable == null) {
                    return "Clipboard must not be empty";
                }
                if (transferable.isDataFlavorSupported(CollectionOfFeaturesTransferable.COLLECTION_OF_FEATURES_FLAVOR)) {
                    return null;
                }
                try {
                    if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor) && this.isWKT((String)transferable.getTransferData(DataFlavor.stringFlavor))) {
                        return null;
                    }
                }
                catch (Exception e) {
                    workbenchContext.getErrorHandler().handleThrowable(e);
                }
                return "Clipboard must contain geometries or Well-Known Text";
            }

            private boolean isWKT(String s) {
                try {
                    new WKTReader().read(new StringReader(s));
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
        });
    }
}

