/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.scalebar;

import com.vividsolutions.jump.util.MathUtil;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.plugin.scalebar.IncrementChooser;
import com.vividsolutions.jump.workbench.ui.plugin.scalebar.MetricSystem;
import com.vividsolutions.jump.workbench.ui.plugin.scalebar.RoundQuantity;
import com.vividsolutions.jump.workbench.ui.renderer.SimpleRenderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;

public class ScaleBarRenderer
extends SimpleRenderer {
    public static final String CONTENT_ID = "SCALE_BAR";
    private static final int BAR_HEIGHT = 10;
    private static final Color FILL2 = new Color(255, 204, 204);
    private static final Color FILL1 = Color.white;
    private static final int HORIZONTAL_MARGIN = 3;
    private static final int IDEAL_INCREMENT = 75;
    private static final Color LINE_COLOR = Color.black;
    private static final int TEXT_BOTTOM_MARGIN = 1;
    private static final int UNIT_TEXT_BOTTOM_MARGIN = 1;
    private static final Color TEXT_COLOR = Color.black;
    private static final Color UNIT_TEXT_COLOR = Color.blue;
    private static final int VERTICAL_MARGIN = 3;
    private static final String ENABLED_KEY = ScaleBarRenderer.class + " - ENABLED";
    private static final int INCREMENT_COUNT = 5;
    private Font FONT = new Font("Dialog", 0, 10);
    private Font UNIT_FONT = new Font("Dialog", 1, 11);
    private Stroke stroke = new BasicStroke();

    public ScaleBarRenderer(LayerViewPanel panel) {
        super(CONTENT_ID, panel);
    }

    public static boolean isEnabled(LayerViewPanel panel) {
        return panel.getBlackboard().get(ENABLED_KEY, false);
    }

    public static void setEnabled(boolean enabled, LayerViewPanel panel) {
        panel.getBlackboard().put(ENABLED_KEY, enabled);
    }

    protected void paint(Graphics2D g) {
        this.paint(g, this.panel.getViewport().getScale());
    }

    public void paint(Graphics2D g, double scale) {
        if (!ScaleBarRenderer.isEnabled(this.panel)) {
            return;
        }
        g.setStroke(this.stroke);
        RoundQuantity increment = new IncrementChooser().chooseGoodIncrement(new MetricSystem(1.0).createUnits(), 75.0 / scale);
        this.paintIncrements(increment, 5, g, scale);
    }

    private int barBottom() {
        return this.panel.getHeight() - 3;
    }

    private int barTop() {
        return this.barBottom() - 10;
    }

    private TextLayout createTextLayout(String text, Font font, Graphics2D g) {
        return new TextLayout(text, font, g.getFontRenderContext());
    }

    private void paintIncrement(int i, RoundQuantity increment, int incrementCount, Graphics2D g, double scale) {
        Rectangle2D.Double shape = new Rectangle2D.Double(this.x(i, increment, incrementCount, scale), this.barTop(), this.x(i + 1, increment, incrementCount, scale) - this.x(i, increment, incrementCount, scale), this.barBottom() - this.barTop());
        g.setColor(i % 2 == 0 ? FILL1 : FILL2);
        g.fill(shape);
        g.setColor(LINE_COLOR);
        g.draw(shape);
    }

    private void paintIncrements(RoundQuantity increment, int incrementCount, Graphics2D g, double scale) {
        for (int i = 0; i < incrementCount; ++i) {
            this.paintIncrement(i, increment, incrementCount, g, scale);
            this.paintLabel(i, increment, incrementCount, g, scale);
        }
    }

    private void paintLabel(int i, RoundQuantity increment, int incrementCount, Graphics2D g, double scale) {
        String text = new RoundQuantity(increment.getMantissa() * (i + 1), increment.getExponent(), increment.getUnit()).getAmountString();
        Font font = this.FONT;
        g.setColor(TEXT_COLOR);
        int textBottomMargin = 1;
        if (i == incrementCount - 1) {
            text = increment.getUnit().getName();
            font = this.UNIT_FONT;
            g.setColor(UNIT_TEXT_COLOR);
            textBottomMargin = 1;
        }
        TextLayout layout = this.createTextLayout(text, font, g);
        double center = MathUtil.avg(this.x(i, increment, incrementCount, scale), this.x(i + 1, increment, incrementCount, scale));
        layout.draw(g, (float)(center - (double)(layout.getAdvance() / 2.0f)), this.barBottom() - textBottomMargin);
    }

    private double x(int i, RoundQuantity increment, int incrementCount, double scale) {
        return 3.0 + (double)i * increment.getModelValue() * scale;
    }
}

