/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer;

import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.renderer.ImageCachingFeatureCollectionRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.Renderer;
import com.vividsolutions.jump.workbench.ui.renderer.SimpleFeatureCollectionRenderer;
import java.awt.Graphics2D;
import java.util.Collection;
import java.util.Map;

public abstract class FeatureCollectionRenderer
implements Renderer {
    private ImageCachingFeatureCollectionRenderer imageCachingFeatureCollectionRenderer;
    private SimpleFeatureCollectionRenderer simpleFeatureCollectionRenderer;
    private Renderer currentFeatureCollectionRenderer;

    public FeatureCollectionRenderer(Object contentID, LayerViewPanel panel) {
        this(contentID, panel, new ImageCachingFeatureCollectionRenderer(contentID, panel));
    }

    public FeatureCollectionRenderer(Object contentID, LayerViewPanel panel, ImageCachingFeatureCollectionRenderer imageCachingFeatureCollectionRenderer) {
        this.imageCachingFeatureCollectionRenderer = imageCachingFeatureCollectionRenderer;
        this.simpleFeatureCollectionRenderer = new SimpleFeatureCollectionRenderer(contentID, panel);
        this.currentFeatureCollectionRenderer = this.simpleFeatureCollectionRenderer;
    }

    public void clearImageCache() {
        this.imageCachingFeatureCollectionRenderer.clearImageCache();
        this.simpleFeatureCollectionRenderer.clearImageCache();
    }

    public boolean isRendering() {
        return this.currentFeatureCollectionRenderer.isRendering();
    }

    public Object getContentID() {
        return this.currentFeatureCollectionRenderer.getContentID();
    }

    public void copyTo(Graphics2D graphics) {
        this.currentFeatureCollectionRenderer.copyTo(graphics);
    }

    public Runnable createRunnable() {
        Map layerToFeaturesMap = this.layerToFeaturesMap();
        Collection styles = this.styles();
        this.imageCachingFeatureCollectionRenderer.setLayerToFeaturesMap(layerToFeaturesMap);
        this.imageCachingFeatureCollectionRenderer.setStyles(styles);
        this.simpleFeatureCollectionRenderer.setLayerToFeaturesMap(layerToFeaturesMap);
        this.simpleFeatureCollectionRenderer.setStyles(styles);
        this.currentFeatureCollectionRenderer = this.featureCount(layerToFeaturesMap) < 100 ? this.simpleFeatureCollectionRenderer : this.imageCachingFeatureCollectionRenderer;
        return this.currentFeatureCollectionRenderer.createRunnable();
    }

    private int featureCount(Map layerToFeaturesMap) {
        int count = 0;
        for (Collection features : layerToFeaturesMap.values()) {
            count += features.size();
        }
        return count;
    }

    protected abstract Map layerToFeaturesMap();

    protected abstract Collection styles();

    public void cancel() {
        this.imageCachingFeatureCollectionRenderer.cancel();
        this.simpleFeatureCollectionRenderer.cancel();
    }
}

