/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.util.OrderedMap;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.WMSLayer;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.renderer.FeatureSelectionRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.LayerRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.LineStringSelectionRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.PartSelectionRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.Renderer;
import com.vividsolutions.jump.workbench.ui.renderer.SelectionBackgroundRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.ThreadQueue;
import com.vividsolutions.jump.workbench.ui.renderer.WMSLayerRenderer;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Timer;

public class RenderingManager {
    private LayerViewPanel panel;
    private Map contentIDToRendererMap = new OrderedMap();
    private OrderedMap contentIDToLowRendererFactoryMap = new OrderedMap();
    private OrderedMap contentIDToHighRendererFactoryMap = new OrderedMap();
    private ThreadQueue defaultRendererThreadQueue = new ThreadQueue(1);
    private ThreadQueue wmsRendererThreadQueue = new ThreadQueue(20);
    private Timer repaintTimer = new Timer(1000, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            for (Renderer renderer : RenderingManager.this.contentIDToRendererMap.values()) {
                if (!renderer.isRendering()) continue;
                RenderingManager.this.repaintPanel();
                return;
            }
            RenderingManager.this.repaintTimer.stop();
            RenderingManager.this.repaintPanel();
        }
    });
    private boolean paintingEnabled = true;

    public RenderingManager(final LayerViewPanel panel) {
        this.panel = panel;
        this.repaintTimer.setCoalesce(true);
        this.putAboveLayerables("SELECTION_BACKGROUND", new Renderer.Factory(){

            public Renderer create() {
                return new SelectionBackgroundRenderer(panel);
            }
        });
        this.putAboveLayerables("SELECTED_FEATURES", new Renderer.Factory(){

            public Renderer create() {
                return new FeatureSelectionRenderer(panel);
            }
        });
        this.putAboveLayerables("SELECTED_LINESTRINGS", new Renderer.Factory(){

            public Renderer create() {
                return new LineStringSelectionRenderer(panel);
            }
        });
        this.putAboveLayerables("SELECTED_PARTS", new Renderer.Factory(){

            public Renderer create() {
                return new PartSelectionRenderer(panel);
            }
        });
    }

    public void putBelowLayerables(Object contentID, Renderer.Factory factory) {
        this.contentIDToLowRendererFactoryMap.put(contentID, factory);
    }

    public void putAboveLayerables(Object contentID, Renderer.Factory factory) {
        this.contentIDToHighRendererFactoryMap.put(contentID, factory);
    }

    public void renderAll() {
        this.defaultRendererThreadQueue.clear();
        this.wmsRendererThreadQueue.clear();
        for (Object contentID : this.contentIDs()) {
            this.render(contentID);
        }
    }

    protected List contentIDs() {
        ArrayList<Layerable> contentIDs = new ArrayList<Layerable>();
        contentIDs.addAll(this.contentIDToLowRendererFactoryMap.keyList());
        Iterator i = this.panel.getLayerManager().reverseIterator(Layerable.class);
        while (i.hasNext()) {
            Layerable layerable = (Layerable)i.next();
            contentIDs.add(layerable);
        }
        contentIDs.addAll(this.contentIDToHighRendererFactoryMap.keyList());
        return contentIDs;
    }

    public Renderer getRenderer(Object contentID) {
        return (Renderer)this.contentIDToRendererMap.get(contentID);
    }

    private void setRenderer(Object contentID, Renderer renderer) {
        this.contentIDToRendererMap.put(contentID, renderer);
    }

    public void render(Object contentID) {
        this.render(contentID, true);
    }

    public void render(Object contentID, boolean clearImageCache) {
        Runnable runnable;
        if (this.getRenderer(contentID) == null) {
            this.setRenderer(contentID, this.createRenderer(contentID));
        }
        if (this.getRenderer(contentID).isRendering()) {
            this.getRenderer(contentID).cancel();
            this.setRenderer(contentID, this.createRenderer(contentID));
        }
        if (clearImageCache) {
            this.getRenderer(contentID).clearImageCache();
        }
        if ((runnable = this.getRenderer(contentID).createRunnable()) != null) {
            (contentID instanceof WMSLayer ? this.wmsRendererThreadQueue : this.defaultRendererThreadQueue).add(runnable);
        }
        if (!this.repaintTimer.isRunning()) {
            this.repaintPanel();
            this.repaintTimer.start();
        }
    }

    public void repaintPanel() {
        if (!this.paintingEnabled) {
            return;
        }
        this.panel.superRepaint();
    }

    protected Renderer createRenderer(Object contentID) {
        if (contentID instanceof Layer) {
            return new LayerRenderer((Layer)contentID, this.panel);
        }
        if (contentID instanceof WMSLayer) {
            return new WMSLayerRenderer((WMSLayer)contentID, this.panel);
        }
        if (this.contentIDToLowRendererFactoryMap.containsKey(contentID)) {
            return ((Renderer.Factory)this.contentIDToLowRendererFactoryMap.get(contentID)).create();
        }
        if (this.contentIDToHighRendererFactoryMap.containsKey(contentID)) {
            return ((Renderer.Factory)this.contentIDToHighRendererFactoryMap.get(contentID)).create();
        }
        Assert.shouldNeverReachHere();
        return null;
    }

    public void setPaintingEnabled(boolean paintingEnabled) {
        this.paintingEnabled = paintingEnabled;
    }

    public void copyTo(Graphics2D destination) {
        for (Object contentID : this.contentIDs()) {
            if (this.getRenderer(contentID) == null) continue;
            this.getRenderer(contentID).copyTo(destination);
        }
    }

    public ThreadQueue getDefaultRendererThreadQueue() {
        return this.defaultRendererThreadQueue;
    }

    public void dispose() {
        this.repaintTimer.stop();
        this.defaultRendererThreadQueue.dispose();
        this.wmsRendererThreadQueue.dispose();
        this.contentIDToRendererMap.clear();
    }
}

