/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.zoom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.geom.EnvelopeUtil;
import com.vividsolutions.jump.util.CoordinateArrays;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;

public class ZoomToCoordinatePlugIn
extends AbstractPlugIn {
    private Coordinate lastCoordinate = new Coordinate(0.0, 0.0);

    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        Coordinate coordinate = this.prompt(context);
        if (coordinate == null) {
            return false;
        }
        this.lastCoordinate = coordinate;
        context.getLayerViewPanel().getViewport().zoom(this.toEnvelope(coordinate, context.getLayerManager()));
        return true;
    }

    private Coordinate prompt(PlugInContext context) {
        while (true) {
            try {
                return this.toCoordinate(JOptionPane.showInputDialog(context.getWorkbenchFrame(), "Enter coordinate to zoom to:", this.lastCoordinate.x + ", " + this.lastCoordinate.y));
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(context.getWorkbenchFrame(), e.getMessage(), context.getWorkbenchFrame().getTitle(), 0);
                continue;
            }
            break;
        }
    }

    private Envelope toEnvelope(Coordinate coordinate, LayerManager layerManager) {
        int segments = 0;
        int segmentSum = 0;
        Iterator i = layerManager.iterator();
        block0: while (i.hasNext()) {
            Layer layer = (Layer)i.next();
            Iterator j = layer.getFeatureCollectionWrapper().iterator();
            while (j.hasNext()) {
                Feature feature = (Feature)j.next();
                List coordinateArrays = CoordinateArrays.toCoordinateArrays(feature.getGeometry(), false);
                for (Coordinate[] coordinates : coordinateArrays) {
                    for (int a = 1; a < coordinates.length; ++a) {
                        segmentSum = (int)((double)segmentSum + coordinates[a].distance(coordinates[a - 1]));
                        if (++segments > 100) break block0;
                    }
                }
            }
        }
        Envelope envelope = new Envelope(coordinate);
        envelope = segmentSum > 0 ? EnvelopeUtil.expand(envelope, (double)segmentSum / (double)segments) : EnvelopeUtil.expand(envelope, 50.0);
        return envelope;
    }

    private Coordinate toCoordinate(String s) throws Exception {
        if (s == null) {
            return null;
        }
        if (s.trim().length() == 0) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(s = StringUtil.replaceAll(s, ",", " "));
        String x = tokenizer.nextToken();
        if (!StringUtil.isNumber(x)) {
            throw new Exception("Not a number: " + x);
        }
        String y = tokenizer.nextToken();
        if (!StringUtil.isNumber(y)) {
            throw new Exception("Not a number: " + y);
        }
        return new Coordinate(Double.parseDouble(x), Double.parseDouble(y));
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck());
    }
}

