/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.zoom;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jump.geom.EnvelopeUtil;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JMenuItem;

public class ZoomToLayerPlugIn
extends AbstractPlugIn {
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        context.getLayerViewPanel().getViewport().zoom(EnvelopeUtil.bufferByFraction(this.envelopeOfSelectedLayers(context), 0.03));
        return true;
    }

    private Envelope envelopeOfSelectedLayers(PlugInContext context) {
        Envelope envelope = new Envelope();
        for (Layer layer : Arrays.asList(context.getLayerNamePanel().getSelectedLayers())) {
            envelope.expandToInclude(layer.getFeatureCollectionWrapper().getEnvelope());
        }
        return envelope;
    }

    public MultiEnableCheck createEnableCheck(final WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustBeSelectedCheck(1)).add(new EnableCheck(){

            public String check(JComponent component) {
                ((JMenuItem)component).setText(ZoomToLayerPlugIn.this.getName() + StringUtil.s(workbenchContext.getLayerNamePanel().getSelectedLayers().length));
                return null;
            }
        });
    }
}

