/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.demo.delineation;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jump.demo.delineation.DelineationUtil;
import com.vividsolutions.jump.demo.delineation.DelineationVertexStyle;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.cursortool.NClickTool;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.Collection;
import javax.swing.Icon;

public class CreateDelineationTool
extends NClickTool {
    private static final String GEOMETRY_ATTRIBUTE_NAME = "GEOMETRY";
    private boolean sourceAnchored;
    private boolean destinationAnchored;
    private GeometryFactory factory = new GeometryFactory();

    public CreateDelineationTool(Collection snapPolicies) {
        super(2);
        this.getSnapManager().addPolicies(snapPolicies);
        this.setColor(DelineationUtil.TOOL_COLOR);
        this.setStrokeWidth(5);
    }

    @Override
    public Icon getIcon() {
        return DelineationUtil.ICON;
    }

    @Override
    protected void gestureFinished() throws NoninvertibleTransformException {
        this.getPanel().setViewportInitialized(true);
        Feature feature = this.createFeature(this.getModelSource(), this.getModelDestination());
        this.delineationLayer().getFeatureCollectionWrapper().add(feature);
    }

    @Override
    public Cursor getCursor() {
        return DelineationUtil.CURSOR;
    }

    protected Shape getShape(Point2D source, Point2D destination) {
        return new Line2D.Double(source, destination);
    }

    @Override
    protected void add(Coordinate c) {
        super.add(c);
        if (this.getCoordinates().size() == 1) {
            this.sourceAnchored = this.getSnapManager().wasSnapCoordinateFound();
        }
        if (this.getCoordinates().size() == 2) {
            this.destinationAnchored = this.getSnapManager().wasSnapCoordinateFound();
        }
    }

    private Feature createFeature(Coordinate source, Coordinate destination) throws NoninvertibleTransformException {
        LineString geometry = this.factory.createLineString(new Coordinate[]{source, destination});
        BasicFeature feature = new BasicFeature(this.delineationLayer().getFeatureCollectionWrapper().getFeatureSchema());
        feature.setAttribute("SOURCE_SNAPPED", (Object)DelineationUtil.toString(this.sourceAnchored));
        feature.setAttribute("DESTINATION_SNAPPED", (Object)DelineationUtil.toString(this.destinationAnchored));
        feature.setGeometry((Geometry)geometry);
        return feature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Layer delineationLayer() {
        Layer layer;
        Layer delineationLayer = this.getPanel().getLayerManager().getLayer("Delineations");
        if (delineationLayer != null) {
            return delineationLayer;
        }
        FeatureSchema schema = new FeatureSchema();
        schema.addAttribute("SOURCE_SNAPPED", AttributeType.STRING);
        schema.addAttribute("DESTINATION_SNAPPED", AttributeType.STRING);
        schema.addAttribute(GEOMETRY_ATTRIBUTE_NAME, AttributeType.GEOMETRY);
        FeatureDataset featureCollection = new FeatureDataset(schema);
        boolean firingEvents = this.getPanel().getLayerManager().isFiringEvents();
        this.getPanel().getLayerManager().setFiringEvents(false);
        try {
            layer = new Layer("Delineations", Color.blue, featureCollection, this.getPanel().getLayerManager());
            layer.removeStyle(layer.getVertexStyle());
            layer.addStyle(new DelineationVertexStyle());
            layer.getBasicStyle().setLineWidth(4);
            layer.getVertexStyle().setEnabled(true);
        }
        finally {
            this.getPanel().getLayerManager().setFiringEvents(firingEvents);
        }
        this.getPanel().getLayerManager().addLayer("Working", layer);
        return layer;
    }
}

