/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.demo.delineation;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jump.demo.delineation.DelineationUtil;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.renderer.style.VertexStyle;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;

public class DelineationVertexStyle
extends VertexStyle {
    public DelineationVertexStyle() {
        super(new Ellipse2D.Double());
    }

    @Override
    public void paint(Feature f, Graphics2D g, Viewport viewport) throws Exception {
        Coordinate[] coordinates = f.getGeometry().getCoordinates();
        DelineationUtil.checkDelineationCoordinates(coordinates);
        g.setColor(this.color(f.getAttribute("SOURCE_SNAPPED").equals("Y")));
        this.paint(g, viewport.toViewPoint(new Point2D.Double(coordinates[0].x, coordinates[0].y)));
        g.setColor(this.color(f.getAttribute("DESTINATION_SNAPPED").equals("Y")));
        this.paint(g, viewport.toViewPoint(new Point2D.Double(coordinates[1].x, coordinates[1].y)));
    }

    private Color color(boolean snapped) {
        return snapped ? Color.green : Color.red;
    }
}

