/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.feature;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureSchema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class FeatureDataset
implements FeatureCollection,
Serializable {
    private static final long serialVersionUID = 5573446944516446540L;
    private FeatureSchema featureSchema;
    private ArrayList features;
    private Envelope envelope = null;

    public FeatureDataset(Collection newFeatures, FeatureSchema featureSchema) {
        this.features = new ArrayList(newFeatures);
        this.featureSchema = featureSchema;
    }

    public FeatureDataset(FeatureSchema featureSchema) {
        this(new ArrayList(), featureSchema);
    }

    public Feature getFeature(int index) {
        return (Feature)this.features.get(index);
    }

    @Override
    public FeatureSchema getFeatureSchema() {
        return this.featureSchema;
    }

    @Override
    public Envelope getEnvelope() {
        if (this.envelope == null) {
            this.envelope = new Envelope();
            for (Feature feature : this.features) {
                this.envelope.expandToInclude(feature.getGeometry().getEnvelopeInternal());
            }
        }
        return this.envelope;
    }

    @Override
    public List getFeatures() {
        return Collections.unmodifiableList(this.features);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public List query(Envelope envelope) {
        if (!envelope.intersects(this.getEnvelope())) {
            return new ArrayList();
        }
        ArrayList<Feature> queryResult = new ArrayList<Feature>();
        for (Feature feature : this.features) {
            if (!feature.getGeometry().getEnvelopeInternal().intersects(envelope)) continue;
            queryResult.add(feature);
        }
        return queryResult;
    }

    @Override
    public void add(Feature feature) {
        this.features.add(feature);
        if (this.envelope != null) {
            this.envelope.expandToInclude(feature.getGeometry().getEnvelopeInternal());
        }
    }

    public boolean contains(Feature feature) {
        return this.features.contains(feature);
    }

    @Override
    public Collection remove(Envelope env) {
        List features = this.query(env);
        this.removeAll(features);
        return features;
    }

    @Override
    public void remove(Feature feature) {
        this.features.remove(feature);
        this.invalidateEnvelope();
    }

    @Override
    public void clear() {
        this.invalidateEnvelope();
        this.features.clear();
    }

    @Override
    public int size() {
        return this.features.size();
    }

    @Override
    public Iterator iterator() {
        return this.features.iterator();
    }

    public void invalidateEnvelope() {
        this.envelope = null;
    }

    @Override
    public void addAll(Collection features) {
        this.features.addAll(features);
        if (this.envelope != null) {
            for (Feature feature : features) {
                this.envelope.expandToInclude(feature.getGeometry().getEnvelopeInternal());
            }
        }
    }

    @Override
    public void removeAll(Collection features) {
        this.features.removeAll(features);
        this.invalidateEnvelope();
    }
}

