/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.datasource;

import com.vividsolutions.jump.workbench.datasource.DataSourceQueryChooser;
import com.vividsolutions.jump.workbench.ui.OKCancelPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DataSourceQueryChooserDialog
extends JDialog {
    private CardLayout cardLayout = new CardLayout();
    private BorderLayout borderLayout2 = new BorderLayout();
    private JPanel mainPanel = new JPanel(this.cardLayout);
    private JPanel formatPanel = new JPanel();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JComboBox formatComboBox = new JComboBox();
    private JLabel formatLabel = new JLabel(){
        {
            this.setDisplayedMnemonic('F');
            this.setLabelFor(DataSourceQueryChooserDialog.this.formatComboBox);
        }
    };
    private HashMap componentToNameMap = new HashMap();
    private OKCancelPanel okCancelPanel = new OKCancelPanel();

    public DataSourceQueryChooserDialog(Collection dataSourceQueryChoosers, Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        this.init(dataSourceQueryChoosers);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                DataSourceQueryChooserDialog.this.okCancelPanel.setOKPressed(false);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DataSourceQueryChooserDialog.this.okCancelPanel.setOKPressed(false);
            }
        });
        this.formatComboBox.setSelectedItem(this.formatComboBox.getItemAt(0));
    }

    private void init(Collection dataSourceQueryChoosers) {
        HashSet<Component> components = new HashSet<Component>();
        for (DataSourceQueryChooser chooser : dataSourceQueryChoosers) {
            this.formatComboBox.addItem(chooser);
            components.add(chooser.getComponent());
        }
        int j = 0;
        for (Component component : components) {
            this.componentToNameMap.put(component, "Card " + ++j);
            this.mainPanel.add(component, this.name(component));
        }
    }

    private String name(Component component) {
        return (String)this.componentToNameMap.get(component);
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.borderLayout2);
        this.formatPanel.setLayout(this.gridBagLayout1);
        this.formatPanel.setBorder(BorderFactory.createEtchedBorder());
        this.formatLabel.setText("Format:");
        this.formatComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataSourceQueryChooserDialog.this.formatComboBox_actionPerformed(e);
            }
        });
        this.okCancelPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataSourceQueryChooserDialog.this.okCancelPanel_actionPerformed(e);
            }
        });
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.getContentPane().add((Component)this.formatPanel, "North");
        this.getContentPane().add((Component)this.okCancelPanel, "South");
        this.formatPanel.add((Component)this.formatComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.formatPanel.add((Component)this.formatLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
    }

    public boolean wasOKPressed() {
        return this.okCancelPanel.wasOKPressed();
    }

    void formatComboBox_actionPerformed(ActionEvent e) {
        this.cardLayout.show(this.mainPanel, this.name(this.getCurrentChooser().getComponent()));
    }

    public DataSourceQueryChooser getCurrentChooser() {
        return (DataSourceQueryChooser)this.formatComboBox.getSelectedItem();
    }

    void okCancelPanel_actionPerformed(ActionEvent e) {
        if (!this.okCancelPanel.wasOKPressed() || this.getCurrentChooser().isInputValid()) {
            this.setVisible(false);
        }
    }

    public String getSelectedFormat() {
        return this.formatComboBox.getSelectedItem().toString();
    }

    public void setSelectedFormat(String format) {
        for (int i = 0; i < this.formatComboBox.getItemCount(); ++i) {
            DataSourceQueryChooser chooser = (DataSourceQueryChooser)this.formatComboBox.getItemAt(i);
            if (!chooser.toString().equals(format)) continue;
            this.formatComboBox.setSelectedIndex(i);
            return;
        }
    }
}

