/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.datasource;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.io.FMEGMLReader;
import com.vividsolutions.jump.io.FMEGMLWriter;
import com.vividsolutions.jump.io.JMLReader;
import com.vividsolutions.jump.io.JMLWriter;
import com.vividsolutions.jump.io.JUMPReader;
import com.vividsolutions.jump.io.JUMPWriter;
import com.vividsolutions.jump.io.ShapefileReader;
import com.vividsolutions.jump.io.ShapefileWriter;
import com.vividsolutions.jump.io.WKTReader;
import com.vividsolutions.jump.io.WKTWriter;
import com.vividsolutions.jump.io.datasource.StandardReaderWriterFileDataSource;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datasource.DataSourceQueryChooserManager;
import com.vividsolutions.jump.workbench.datasource.GMLDataSourceQueryChooserInstaller;
import com.vividsolutions.jump.workbench.datasource.LoadFileDataSourceQueryChooser;
import com.vividsolutions.jump.workbench.datasource.SaveFileDataSourceQueryChooser;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import javax.swing.JFileChooser;

public class InstallStandardDataSourceQueryChoosersPlugIn
extends AbstractPlugIn {
    private void addFileDataSourceQueryChoosers(JUMPReader reader, JUMPWriter writer, final String description, WorkbenchContext context, Class readerWriterDataSourceClass) {
        DataSourceQueryChooserManager chooserManager = DataSourceQueryChooserManager.get(context.getBlackboard());
        chooserManager.addLoadDataSourceQueryChooser(new LoadFileDataSourceQueryChooser(readerWriterDataSourceClass, description, InstallStandardDataSourceQueryChoosersPlugIn.extensions(readerWriterDataSourceClass), context){

            @Override
            protected void addFileFilters(JFileChooser chooser) {
                super.addFileFilters(chooser);
                InstallStandardDataSourceQueryChoosersPlugIn.addCompressedFileFilter(description, chooser);
            }
        });
        chooserManager.addSaveDataSourceQueryChooser(new SaveFileDataSourceQueryChooser(readerWriterDataSourceClass, description, InstallStandardDataSourceQueryChoosersPlugIn.extensions(readerWriterDataSourceClass), context));
    }

    public static String[] extensions(Class readerWriterDataSourceClass) {
        String[] exts = null;
        try {
            exts = ((StandardReaderWriterFileDataSource)readerWriterDataSourceClass.newInstance()).getExtensions();
        }
        catch (Exception e) {
            Assert.shouldNeverReachHere((String)e.toString());
        }
        return exts;
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        this.addFileDataSourceQueryChoosers(new JMLReader(), new JMLWriter(), "JUMP GML", context.getWorkbenchContext(), StandardReaderWriterFileDataSource.JML.class);
        new GMLDataSourceQueryChooserInstaller().addLoadGMLFileDataSourceQueryChooser(context);
        new GMLDataSourceQueryChooserInstaller().addSaveGMLFileDataSourceQueryChooser(context);
        this.addFileDataSourceQueryChoosers(new FMEGMLReader(), new FMEGMLWriter(), "FME GML", context.getWorkbenchContext(), StandardReaderWriterFileDataSource.FMEGML.class);
        this.addFileDataSourceQueryChoosers(new WKTReader(), new WKTWriter(), "WKT", context.getWorkbenchContext(), StandardReaderWriterFileDataSource.WKT.class);
        this.addFileDataSourceQueryChoosers(new ShapefileReader(), new ShapefileWriter(), "ESRI Shapefile", context.getWorkbenchContext(), StandardReaderWriterFileDataSource.Shapefile.class);
    }

    public static void addCompressedFileFilter(String description, JFileChooser chooser) {
        chooser.addChoosableFileFilter(GUIUtil.createFileFilter("Compressed " + description, new String[]{"zip", "gz"}));
    }
}

